/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.index;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.MetaAnnotatable;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.graphdb.database.index.IndexMutationType;
import org.janusgraph.graphdb.types.IndexType;

public class IndexUpdate<K, E> {
    private final IndexType index;
    private final IndexMutationType mutationType;
    private final K key;
    private final E entry;
    private final JanusGraphElement element;

    public IndexUpdate(IndexType index, IndexMutationType mutationType, K key, E entry, JanusGraphElement element) {
        assert (index != null && mutationType != null && key != null && entry != null && element != null);
        assert (!index.isCompositeIndex() || key instanceof StaticBuffer && entry instanceof Entry);
        assert (!index.isMixedIndex() || key instanceof String && entry instanceof IndexEntry);
        this.index = index;
        this.mutationType = mutationType;
        this.key = key;
        this.entry = entry;
        this.element = element;
    }

    public JanusGraphElement getElement() {
        return this.element;
    }

    public IndexType getIndex() {
        return this.index;
    }

    public IndexMutationType getType() {
        return this.mutationType;
    }

    public K getKey() {
        return this.key;
    }

    public E getEntry() {
        return this.entry;
    }

    public boolean isUpdate() {
        return this.mutationType == IndexMutationType.UPDATE;
    }

    public boolean isDeletion() {
        return this.mutationType == IndexMutationType.DELETE;
    }

    public boolean isCompositeIndex() {
        return this.index.isCompositeIndex();
    }

    public boolean isMixedIndex() {
        return this.index.isMixedIndex();
    }

    public void setTTL(int ttl) {
        Preconditions.checkArgument((ttl > 0 && this.mutationType != IndexMutationType.DELETE ? 1 : 0) != 0);
        ((MetaAnnotatable)this.entry).setMetaData(EntryMetaData.TTL, ttl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.mutationType, this.key, this.entry});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof IndexUpdate)) {
            return false;
        }
        IndexUpdate oth = (IndexUpdate)other;
        return this.index.equals(oth.index) && this.mutationType == oth.mutationType && this.key.equals(oth.key) && this.entry.equals(oth.entry);
    }
}

