/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;

public class JsonUtil {
    public static <T> T jsonResourcePathToObject(String resourcePath, Class<T> parsedClass) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream resourceStream = loader.getResourceAsStream(resourcePath);
        return JsonUtil.jsonToObject(new InputStreamReader(resourceStream), parsedClass);
    }

    public static <T> T jsonFilePathToObject(String filePath, Class<T> parsedClass) throws IOException {
        return JsonUtil.jsonToObject(new FileReader(filePath), parsedClass);
    }

    public static <T> T jsonStringToObject(String json, Class<T> parsedClass) throws IOException {
        return JsonUtil.jsonToObject(new StringReader(json), parsedClass);
    }

    public static <T> T jsonToObject(Reader reader, Class<T> parsedClass) throws IOException {
        return (T)new ObjectMapper().readValue(reader, parsedClass);
    }
}

