/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.parser;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.json.creator.SchemaCreationException;
import org.janusgraph.core.schema.json.definition.JsonParameterDefinition;
import org.janusgraph.core.schema.json.parser.BooleanJsonParameterParser;
import org.janusgraph.core.schema.json.parser.ByteJsonParameterParser;
import org.janusgraph.core.schema.json.parser.DoubleJsonParameterParser;
import org.janusgraph.core.schema.json.parser.EnumJsonParameterParser;
import org.janusgraph.core.schema.json.parser.FloatJsonParameterParser;
import org.janusgraph.core.schema.json.parser.IntegerJsonParameterParser;
import org.janusgraph.core.schema.json.parser.JsonParameterParser;
import org.janusgraph.core.schema.json.parser.LongJsonParameterParser;
import org.janusgraph.core.schema.json.parser.ShortJsonParameterParser;
import org.janusgraph.core.schema.json.parser.StringJsonParameterParser;

public class JsonParameterDefinitionParser {
    public static final String STRING_PARAMETER_PARSER_NAME = "string";
    public static final String ENUM_PARAMETER_PARSER_NAME = "enum";
    public static final String BOOLEAN_PARAMETER_PARSER_NAME = "boolean";
    public static final String BYTE_PARAMETER_PARSER_NAME = "byte";
    public static final String SHORT_PARAMETER_PARSER_NAME = "short";
    public static final String INTEGER_PARAMETER_PARSER_NAME = "integer";
    public static final String LONG_PARAMETER_PARSER_NAME = "long";
    public static final String FLOAT_PARAMETER_PARSER_NAME = "float";
    public static final String DOUBLE_PARAMETER_PARSER_NAME = "double";
    public final Map<String, JsonParameterParser> jsonParameterParsers = new HashMap<String, JsonParameterParser>();

    public JsonParameterDefinitionParser() {
        this.jsonParameterParsers.put(STRING_PARAMETER_PARSER_NAME, new StringJsonParameterParser());
        this.jsonParameterParsers.put(ENUM_PARAMETER_PARSER_NAME, new EnumJsonParameterParser());
        this.jsonParameterParsers.put(BOOLEAN_PARAMETER_PARSER_NAME, new BooleanJsonParameterParser());
        this.jsonParameterParsers.put(BYTE_PARAMETER_PARSER_NAME, new ByteJsonParameterParser());
        this.jsonParameterParsers.put(SHORT_PARAMETER_PARSER_NAME, new ShortJsonParameterParser());
        this.jsonParameterParsers.put(INTEGER_PARAMETER_PARSER_NAME, new IntegerJsonParameterParser());
        this.jsonParameterParsers.put(LONG_PARAMETER_PARSER_NAME, new LongJsonParameterParser());
        this.jsonParameterParsers.put(FLOAT_PARAMETER_PARSER_NAME, new FloatJsonParameterParser());
        this.jsonParameterParsers.put(DOUBLE_PARAMETER_PARSER_NAME, new DoubleJsonParameterParser());
    }

    public Parameter parse(JsonParameterDefinition definition) {
        JsonParameterParser parameterParser;
        String parserClassPath = definition.getParser();
        if (StringUtils.isEmpty((CharSequence)parserClassPath)) {
            parserClassPath = STRING_PARAMETER_PARSER_NAME;
        }
        if ((parameterParser = this.jsonParameterParsers.get(parserClassPath)) == null) {
            try {
                Class<?> parserClass = Class.forName(parserClassPath);
                Object instance = parserClass.newInstance();
                if (!(instance instanceof JsonParameterParser)) {
                    throw new SchemaCreationException("Class " + parserClassPath + " does not implement JsonParameterParser");
                }
                parameterParser = (JsonParameterParser)instance;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new SchemaCreationException(e);
            }
            this.jsonParameterParsers.put(parserClassPath, parameterParser);
        }
        return parameterParser.parse(definition.getKey(), definition.getValue());
    }
}

