/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.creator.index;

import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreationContext;
import org.janusgraph.core.schema.json.creator.index.AbstractJsonVertexCentricIndexCreator;
import org.janusgraph.core.schema.json.definition.index.JsonVertexCentricEdgeIndexDefinition;

public class JsonVertexCentricEdgeIndexCreator
extends AbstractJsonVertexCentricIndexCreator<JsonVertexCentricEdgeIndexDefinition> {
    @Override
    protected Index buildIndex(JsonVertexCentricEdgeIndexDefinition definition, JsonSchemaCreationContext context) {
        JanusGraphManagement graphManagement = context.getGraphManagement();
        EdgeLabel edgeLabel = graphManagement.getEdgeLabel(definition.getIndexedEdgeLabel());
        PropertyKey[] propertyKeys = this.toPropertyKeys(definition, context);
        if (definition.getOrder() == null) {
            return graphManagement.buildEdgeIndex(edgeLabel, definition.getName(), definition.getDirection(), propertyKeys);
        }
        return graphManagement.buildEdgeIndex(edgeLabel, definition.getName(), definition.getDirection(), definition.getOrder(), propertyKeys);
    }

    @Override
    protected String getIndexedElementName(JsonVertexCentricEdgeIndexDefinition definition) {
        return definition.getIndexedEdgeLabel();
    }
}

