/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.creator.index;

import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreationContext;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreator;
import org.janusgraph.core.schema.json.definition.index.AbstractJsonIndexDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonIndexCreator<T extends AbstractJsonIndexDefinition>
implements JsonSchemaCreator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJsonIndexCreator.class);

    @Override
    public boolean create(T definition, JsonSchemaCreationContext context) {
        if (this.containsIndex(definition, context)) {
            LOG.info("Index with name [{}] was skipped because it already exists.", (Object)((AbstractJsonIndexDefinition)definition).getName());
            return false;
        }
        Index index = this.buildIndex(definition, context);
        LOG.info("Index {} was created", (Object)index.name());
        context.getCreatedOrUpdatedIndices().add((AbstractJsonIndexDefinition)definition);
        return true;
    }

    protected abstract boolean containsIndex(T var1, JsonSchemaCreationContext var2);

    protected abstract Index buildIndex(T var1, JsonSchemaCreationContext var2);
}

