/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.creator;

import java.time.Duration;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.VertexLabelMaker;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreationContext;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreator;
import org.janusgraph.core.schema.json.definition.JsonVertexLabelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonVertexSchemaCreator
implements JsonSchemaCreator<JsonVertexLabelDefinition> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonVertexSchemaCreator.class);

    @Override
    public boolean create(JsonVertexLabelDefinition definition, JsonSchemaCreationContext context) {
        JanusGraphManagement graphManagement = context.getGraphManagement();
        if (this.isVertexExists(graphManagement, definition)) {
            LOGGER.info("Creation of the vertex {} was skipped because it is already exists.", (Object)definition.getLabel());
            return false;
        }
        VertexLabel vertexLabel = this.createVertex(graphManagement, definition);
        if (definition.getTtl() != null) {
            graphManagement.setTTL(vertexLabel, Duration.ofMillis(definition.getTtl()));
        }
        LOGGER.info("Vertex {} was created", (Object)definition.getLabel());
        return true;
    }

    private VertexLabel createVertex(JanusGraphManagement graphManagement, JsonVertexLabelDefinition definition) {
        VertexLabelMaker vertexLabelMaker = graphManagement.makeVertexLabel(definition.getLabel());
        if (Boolean.TRUE.equals(definition.getPartition())) {
            vertexLabelMaker.partition();
        }
        if (Boolean.TRUE.equals(definition.getStaticVertex())) {
            vertexLabelMaker.setStatic();
        }
        return vertexLabelMaker.make();
    }

    private boolean isVertexExists(JanusGraphManagement graphManagement, JsonVertexLabelDefinition definition) {
        return graphManagement.containsVertexLabel(definition.getLabel());
    }
}

