/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.creator;

import java.time.Duration;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreationContext;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreator;
import org.janusgraph.core.schema.json.creator.SchemaCreationException;
import org.janusgraph.core.schema.json.definition.JsonPropertyKeyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPropertySchemaCreator
implements JsonSchemaCreator<JsonPropertyKeyDefinition> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPropertySchemaCreator.class);

    @Override
    public boolean create(JsonPropertyKeyDefinition definition, JsonSchemaCreationContext context) {
        JanusGraphManagement graphManagement = context.getGraphManagement();
        if (this.isPropertyExists(graphManagement, definition)) {
            LOGGER.info("Creation of the property {} was skipped because it is already exists.", (Object)definition.getKey());
            return false;
        }
        PropertyKey propertyKey = this.createProperty(graphManagement, definition);
        if (definition.getTtl() != null) {
            graphManagement.setTTL(propertyKey, Duration.ofMillis(definition.getTtl()));
        }
        if (definition.getConsistency() != null) {
            graphManagement.setConsistency(propertyKey, definition.getConsistency());
        }
        LOGGER.info("Property {} was created", (Object)definition.getKey());
        return true;
    }

    private PropertyKey createProperty(JanusGraphManagement graphManagement, JsonPropertyKeyDefinition definition) {
        Class<?> propertyTypeClass;
        try {
            propertyTypeClass = Class.forName(definition.getClassName());
        }
        catch (Exception e) {
            throw new SchemaCreationException(e);
        }
        PropertyKeyMaker propertyKeyMaker = graphManagement.makePropertyKey(definition.getKey()).dataType(propertyTypeClass);
        if (definition.getCardinality() != null) {
            propertyKeyMaker.cardinality(definition.getCardinality());
        }
        return propertyKeyMaker.make();
    }

    private boolean isPropertyExists(JanusGraphManagement graphManagement, JsonPropertyKeyDefinition definition) {
        return graphManagement.containsPropertyKey(definition.getKey());
    }
}

