/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.creator;

import java.time.Duration;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.schema.EdgeLabelMaker;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreationContext;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreator;
import org.janusgraph.core.schema.json.definition.JsonEdgeLabelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonEdgeSchemaCreator
implements JsonSchemaCreator<JsonEdgeLabelDefinition> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonEdgeSchemaCreator.class);

    @Override
    public boolean create(JsonEdgeLabelDefinition definition, JsonSchemaCreationContext context) {
        JanusGraphManagement graphManagement = context.getGraphManagement();
        if (this.isEdgeExists(graphManagement, definition)) {
            LOGGER.info("Creation of the edge {} was skipped because it is already exists.", (Object)definition.getLabel());
            return false;
        }
        EdgeLabel edgeLabel = this.createEdge(graphManagement, definition);
        if (definition.getTtl() != null) {
            graphManagement.setTTL(edgeLabel, Duration.ofMillis(definition.getTtl()));
        }
        if (definition.getConsistency() != null) {
            graphManagement.setConsistency(edgeLabel, definition.getConsistency());
        }
        LOGGER.info("Edge {} was created", (Object)definition.getLabel());
        return true;
    }

    private EdgeLabel createEdge(JanusGraphManagement graphManagement, JsonEdgeLabelDefinition definition) {
        EdgeLabelMaker edgeLabelMaker = graphManagement.makeEdgeLabel(definition.getLabel());
        if (Boolean.TRUE.equals(definition.getUnidirected())) {
            edgeLabelMaker.unidirected();
        } else {
            edgeLabelMaker.directed();
        }
        if (definition.getMultiplicity() != null) {
            edgeLabelMaker.multiplicity(definition.getMultiplicity());
        }
        return edgeLabelMaker.make();
    }

    private boolean isEdgeExists(JanusGraphManagement graphManagement, JsonEdgeLabelDefinition definition) {
        return graphManagement.containsEdgeLabel(definition.getLabel());
    }
}

