/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.creator;

import org.apache.commons.collections.CollectionUtils;
import org.janusgraph.core.schema.json.creator.JsonEdgeSchemaCreator;
import org.janusgraph.core.schema.json.creator.JsonPropertySchemaCreator;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreationContext;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreator;
import org.janusgraph.core.schema.json.creator.JsonVertexSchemaCreator;
import org.janusgraph.core.schema.json.creator.index.JsonCompositeIndexCreator;
import org.janusgraph.core.schema.json.creator.index.JsonMixedIndexCreator;
import org.janusgraph.core.schema.json.creator.index.JsonVertexCentricEdgeIndexCreator;
import org.janusgraph.core.schema.json.creator.index.JsonVertexCentricPropertyIndexCreator;
import org.janusgraph.core.schema.json.definition.JsonEdgeLabelDefinition;
import org.janusgraph.core.schema.json.definition.JsonPropertyKeyDefinition;
import org.janusgraph.core.schema.json.definition.JsonSchemaDefinition;
import org.janusgraph.core.schema.json.definition.JsonVertexLabelDefinition;
import org.janusgraph.core.schema.json.definition.index.JsonCompositeIndexDefinition;
import org.janusgraph.core.schema.json.definition.index.JsonMixedIndexDefinition;
import org.janusgraph.core.schema.json.definition.index.JsonVertexCentricEdgeIndexDefinition;
import org.janusgraph.core.schema.json.definition.index.JsonVertexCentricPropertyIndexDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralJsonSchemaCreator
implements JsonSchemaCreator<JsonSchemaDefinition> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralJsonSchemaCreator.class);
    private final JsonPropertySchemaCreator propertySchemaCreator = new JsonPropertySchemaCreator();
    private final JsonVertexSchemaCreator vertexSchemaCreator = new JsonVertexSchemaCreator();
    private final JsonEdgeSchemaCreator edgeSchemaCreator = new JsonEdgeSchemaCreator();
    private final JsonCompositeIndexCreator compositeIndexCreator = new JsonCompositeIndexCreator();
    private final JsonMixedIndexCreator mixedIndexCreator = new JsonMixedIndexCreator();
    private final JsonVertexCentricEdgeIndexCreator vertexCentricEdgeIndexCreator = new JsonVertexCentricEdgeIndexCreator();
    private final JsonVertexCentricPropertyIndexCreator vertexCentricPropertyIndexCreator = new JsonVertexCentricPropertyIndexCreator();

    @Override
    public boolean create(JsonSchemaDefinition generalDefinition, JsonSchemaCreationContext context) {
        LOGGER.info("Starting general schema initialization.");
        boolean wasUpdated = false;
        if (context.isCreateSchemaElements()) {
            if (CollectionUtils.isNotEmpty(generalDefinition.getPropertyKeys())) {
                for (JsonPropertyKeyDefinition jsonPropertyKeyDefinition : generalDefinition.getPropertyKeys()) {
                    wasUpdated |= this.propertySchemaCreator.create(jsonPropertyKeyDefinition, context);
                }
            }
            if (CollectionUtils.isNotEmpty(generalDefinition.getVertexLabels())) {
                for (JsonVertexLabelDefinition jsonVertexLabelDefinition : generalDefinition.getVertexLabels()) {
                    wasUpdated |= this.vertexSchemaCreator.create(jsonVertexLabelDefinition, context);
                }
            }
            if (CollectionUtils.isNotEmpty(generalDefinition.getEdgeLabels())) {
                for (JsonEdgeLabelDefinition jsonEdgeLabelDefinition : generalDefinition.getEdgeLabels()) {
                    wasUpdated |= this.edgeSchemaCreator.create(jsonEdgeLabelDefinition, context);
                }
            }
        }
        if (context.isCreateIndices()) {
            if (CollectionUtils.isNotEmpty(generalDefinition.getCompositeIndexes())) {
                for (JsonCompositeIndexDefinition jsonCompositeIndexDefinition : generalDefinition.getCompositeIndexes()) {
                    wasUpdated |= this.compositeIndexCreator.create(jsonCompositeIndexDefinition, context);
                }
            }
            if (CollectionUtils.isNotEmpty(generalDefinition.getMixedIndexes())) {
                for (JsonMixedIndexDefinition jsonMixedIndexDefinition : generalDefinition.getMixedIndexes()) {
                    wasUpdated |= this.mixedIndexCreator.create(jsonMixedIndexDefinition, context);
                }
            }
            if (CollectionUtils.isNotEmpty(generalDefinition.getVertexCentricEdgeIndexes())) {
                for (JsonVertexCentricEdgeIndexDefinition jsonVertexCentricEdgeIndexDefinition : generalDefinition.getVertexCentricEdgeIndexes()) {
                    wasUpdated |= this.vertexCentricEdgeIndexCreator.create(jsonVertexCentricEdgeIndexDefinition, context);
                }
            }
            if (CollectionUtils.isNotEmpty(generalDefinition.getVertexCentricPropertyIndexes())) {
                for (JsonVertexCentricPropertyIndexDefinition jsonVertexCentricPropertyIndexDefinition : generalDefinition.getVertexCentricPropertyIndexes()) {
                    wasUpdated |= this.vertexCentricPropertyIndexCreator.create(jsonVertexCentricPropertyIndexDefinition, context);
                }
            }
        }
        if (wasUpdated) {
            LOGGER.info("Schema initialization complete.");
        } else {
            LOGGER.info("There was no any changes during schema initialization. Schema initialization is skipped.");
        }
        return wasUpdated;
    }
}

