/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.schema.JsonSchemaInitStrategy;
import org.janusgraph.core.schema.NoneSchemaInitStrategy;
import org.janusgraph.core.schema.SchemaInitStrategy;
import org.janusgraph.core.schema.SchemaInitType;
import org.janusgraph.core.schema.json.creator.SchemaCreationException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaInitializationManager {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaInitializationManager.class);
    public static final Map<String, SchemaInitStrategy> SCHEMA_INIT_STRATEGIES = new HashMap<String, SchemaInitStrategy>(1);

    public static JanusGraph initializeSchemaAndStart(GraphDatabaseConfiguration graphDatabaseConfiguration) {
        JanusGraph graph;
        String schemaInitStrategyPath;
        SchemaInitStrategy schemaInitStrategy;
        if (graphDatabaseConfiguration.isDropSchemaBeforeInit()) {
            try {
                LOG.info("Dropping current JanusGraph schema and data.");
                JanusGraphFactory.drop(new StandardJanusGraph(graphDatabaseConfiguration));
                LOG.info("Current JanusGraph schema and data were removed.");
            }
            catch (BackendException e) {
                throw new SchemaCreationException(e);
            }
        }
        if ((schemaInitStrategy = SCHEMA_INIT_STRATEGIES.get(schemaInitStrategyPath = graphDatabaseConfiguration.getSchemaInitStrategy())) == null) {
            try {
                Class<?> schemaInitStrategyClass = Class.forName(schemaInitStrategyPath);
                schemaInitStrategy = (SchemaInitStrategy)schemaInitStrategyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new SchemaCreationException(e);
            }
        }
        if ((graph = schemaInitStrategy.initializeSchemaAndStart(graphDatabaseConfiguration)) == null) {
            graph = new StandardJanusGraph(graphDatabaseConfiguration);
        }
        return graph;
    }

    static {
        SCHEMA_INIT_STRATEGIES.put(SchemaInitType.NONE.getConfigName(), new NoneSchemaInitStrategy());
        SCHEMA_INIT_STRATEGIES.put(SchemaInitType.JSON.getConfigName(), new JsonSchemaInitStrategy());
    }
}

