/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import java.util.HashMap;
import java.util.Map;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.types.CompositeIndexType;

public class CompositeIndexInfo {
    final CompositeIndexType compositeIndexType;
    final Object[] indexFieldValues;
    final Map<PropertyKey, Object> indexValues;

    public CompositeIndexInfo(CompositeIndexType compositeIndexType, Object[] indexFieldValues) {
        this.compositeIndexType = compositeIndexType;
        this.indexFieldValues = indexFieldValues;
        this.indexValues = new HashMap<PropertyKey, Object>();
        for (int i = 0; i < compositeIndexType.getFieldKeys().length; ++i) {
            PropertyKey p = compositeIndexType.getFieldKeys()[i].getFieldKey();
            Object v = indexFieldValues[i];
            this.indexValues.put(p, v);
        }
    }

    public CompositeIndexType getCompositeIndexType() {
        return this.compositeIndexType;
    }

    public String getIndexName() {
        return this.compositeIndexType.getName();
    }

    public Map<PropertyKey, Object> getValues() {
        return this.indexValues;
    }
}

