/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jgroups.PhysicalAddress;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Util;

public class JahiaPingData
extends PingData {
    private String hazelcastPort;

    public JahiaPingData() {
    }

    JahiaPingData(PingData data, String hazelcastPort) {
        super(data.sender, null, data.is_server, data.logical_name, data.physical_addrs);
        this.hazelcastPort = hazelcastPort;
    }

    public String getHazelcastAddress() {
        if (this.physical_addrs != null && !this.physical_addrs.isEmpty()) {
            String jGroupsAddr = ((PhysicalAddress)this.physical_addrs.iterator().next()).toString();
            return StringUtils.substringBeforeLast((String)jGroupsAddr, (String)":") + ":" + this.hazelcastPort;
        }
        return null;
    }

    public void readFrom(DataInput instream) throws Exception {
        super.readFrom(instream);
        this.hazelcastPort = Util.readString((DataInput)instream);
    }

    public void writeTo(DataOutput outstream) throws Exception {
        super.writeTo(outstream);
        Util.writeString((String)this.hazelcastPort, (DataOutput)outstream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JahiaPingData that = (JahiaPingData)((Object)o);
        return this.hazelcastPort.equals(that.hazelcastPort);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hazelcastPort);
    }
}

