/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.sql.Connection;
import java.sql.SQLException;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.JDBC_PING;
import org.jgroups.protocols.JahiaPingData;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class JAHIA_JDBC_PING
extends JDBC_PING {
    public static final short PROTOCOL_ID = 513;
    @Property(description="Specifies the auto-commit handling on the JDBC connection, when it is obtained from a JNDI datasource and when it returned back. If set to 'enforce' (this is the default value) the auto-commit is always set to true. The 'check' first checks if the auto-commit is false and only in this case sets it to true. The 'skip' value bypasses special handling and leaves auto-commit as it is")
    protected String auto_commit = "enforce";
    private AUTO_COMMIT autoCommitMode = AUTO_COMMIT.ENFORCE;

    protected void closeConnection(Connection connection) {
        super.closeConnection(this.ensureAutoCommit(connection));
    }

    private Connection ensureAutoCommit(Connection connection) {
        if (connection == null || AUTO_COMMIT.SKIP == this.autoCommitMode) {
            return connection;
        }
        try {
            if (AUTO_COMMIT.ENFORCE == this.autoCommitMode || !connection.getAutoCommit()) {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("Unable to check/set autocommit on connection", (Throwable)e);
            }
            this.log.warn("Unable to check/set autocommit on connection. Cause: " + e.getMessage());
        }
        return connection;
    }

    protected Connection getConnection() {
        return this.ensureAutoCommit(super.getConnection());
    }

    public void init() throws Exception {
        super.init();
        if (this.datasource_jndi_name == null || this.datasource_jndi_name.trim().length() == 0) {
            this.autoCommitMode = AUTO_COMMIT.SKIP;
            this.auto_commit = "skip";
        } else if (this.auto_commit != null) {
            this.autoCommitMode = AUTO_COMMIT.valueOf(this.auto_commit.trim().toUpperCase());
        }
    }

    protected byte[] serializeWithoutView(PingData data) {
        JahiaPingData extendedData = new JahiaPingData(data, System.getProperty("cluster.hazelcast.bindPort"));
        try {
            return Util.streamableToByteBuffer((Streamable)extendedData);
        }
        catch (Exception e) {
            this.log.error("Error", (Throwable)e);
            return new byte[0];
        }
    }

    static {
        ClassConfigurator.addProtocol((short)513, JAHIA_JDBC_PING.class);
    }

    private static enum AUTO_COMMIT {
        CHECK,
        ENFORCE,
        SKIP;

    }
}

