/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.zip;

import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jahia.utils.zip.PathFilter;

public class ExclusionWildcardFilter
implements PathFilter {
    private String[] excludedResources;

    public ExclusionWildcardFilter(List<String> excludedResources) {
        this.excludedResources = excludedResources.toArray(new String[0]);
    }

    public ExclusionWildcardFilter(String ... excludedResources) {
        this.excludedResources = excludedResources;
    }

    @Override
    public boolean accept(String path) {
        if (this.excludedResources == null || this.excludedResources.length == 0) {
            return true;
        }
        boolean accept = true;
        for (String excludePattern : this.excludedResources) {
            if (!FilenameUtils.wildcardMatch((String)path, (String)excludePattern)) continue;
            accept = false;
            break;
        }
        return accept;
    }
}

