/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.regex.Pattern;

public final class Patterns {
    public static final Properties CHARMAP = new Properties();
    public static final Pattern AT;
    public static final Pattern BACKSLASH;
    public static final Pattern COLON;
    public static final Pattern COMMA;
    public static final Pattern COMMA_WHITESPACE;
    public static final Pattern DASH;
    public static final Pattern DOLLAR;
    public static final Pattern DOT;
    public static final Pattern DOUBLE_QUOTE;
    public static final Pattern EXCLAMATION_MARK;
    public static final Pattern NUMBERS;
    public static final Pattern PERCENT;
    public static final Pattern PIPE;
    public static final Pattern PLUS;
    public static final Pattern SEMICOLON;
    public static final Pattern SINGLE_QUOTE;
    public static final Pattern SLASH;
    public static final Pattern SPACE;
    public static final Pattern ACCENTS;
    public static final Pattern NON_ALLOWED_CHARS;
    public static final Pattern CONSECUTIVE_DASHES;
    public static final Pattern HEADING_DASH;
    public static final Pattern TRAILING_DASH;
    public static final Pattern STAR;
    public static final Pattern TRIPLE_HASH;
    public static final Pattern TRIPPLE_DOLLAR;
    public static final Pattern TRIPPLE_UNDERSCORE;
    public static final Pattern UNDERSCORE;
    public static final Pattern WEB_INF;

    private Patterns() {
    }

    static {
        try (InputStreamReader reader = new InputStreamReader(Patterns.class.getResourceAsStream("/org/jahia/utils/charmap.txt"), Charset.forName("UTF-8"));){
            CHARMAP.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        AT = Pattern.compile("@", 16);
        BACKSLASH = Pattern.compile("\\", 16);
        COLON = Pattern.compile(":", 16);
        COMMA = Pattern.compile(",", 16);
        COMMA_WHITESPACE = Pattern.compile("[\\s,]+");
        DASH = Pattern.compile("-", 16);
        DOLLAR = Pattern.compile("$", 16);
        DOT = Pattern.compile(".", 16);
        DOUBLE_QUOTE = Pattern.compile("\"", 16);
        EXCLAMATION_MARK = Pattern.compile("!", 16);
        NUMBERS = Pattern.compile("[0-9]+");
        PERCENT = Pattern.compile("%", 16);
        PIPE = Pattern.compile("|", 16);
        PLUS = Pattern.compile("+", 16);
        SEMICOLON = Pattern.compile(";", 16);
        SINGLE_QUOTE = Pattern.compile("'", 16);
        SLASH = Pattern.compile("/", 16);
        SPACE = Pattern.compile(" ", 16);
        ACCENTS = Pattern.compile("[\u0300-\u036f]");
        NON_ALLOWED_CHARS = Pattern.compile("[^\\w\\-]");
        CONSECUTIVE_DASHES = Pattern.compile("-+");
        HEADING_DASH = Pattern.compile("^-");
        TRAILING_DASH = Pattern.compile("-$");
        STAR = Pattern.compile("*", 16);
        TRIPLE_HASH = Pattern.compile("###", 16);
        TRIPPLE_DOLLAR = Pattern.compile("$$$", 16);
        TRIPPLE_UNDERSCORE = Pattern.compile("___", 16);
        UNDERSCORE = Pattern.compile("_", 16);
        WEB_INF = Pattern.compile("/WEB-INF", 16);
    }
}

