/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeIterator;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.utils.NodeTypeTreeEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypesUtils {
    private static Logger logger = LoggerFactory.getLogger(NodeTypesUtils.class);

    public static Set<NodeTypeTreeEntry> getContentTypesAsTree(List<String> nodeTypes, List<String> excludedNodeTypes, boolean includeSubTypes, String path, JCRSessionWrapper session, Locale uiLocale) throws RepositoryException {
        NodeTypeTreeEntry nodeTypeTreeEntry;
        ArrayList<JahiaTemplatesPackage> packages = new ArrayList<JahiaTemplatesPackage>();
        JCRSiteNode site = session.getNode(path).getResolveSite();
        if (site.isNodeType("jnt:module")) {
            packages.add(site.getTemplatePackage());
        } else {
            for (String s : site.getInstalledModules()) {
                JahiaTemplatesPackage jahiaTemplatesPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(s);
                packages.add(jahiaTemplatesPackage);
            }
        }
        for (int i = 0; i < packages.size(); ++i) {
            JahiaTemplatesPackage aPackage = (JahiaTemplatesPackage)packages.get(i);
            if (aPackage == null) continue;
            for (JahiaTemplatesPackage jahiaTemplatesPackage : aPackage.getDependencies()) {
                if (packages.contains(jahiaTemplatesPackage)) continue;
                packages.add(jahiaTemplatesPackage);
            }
        }
        ArrayList<ExtendedNodeType> types = new ArrayList<ExtendedNodeType>();
        for (JahiaTemplatesPackage jahiaTemplatesPackage : packages) {
            if (jahiaTemplatesPackage == null) continue;
            NodeTypeRegistry.JahiaNodeTypeIterator jahiaNodeTypeIterator = NodeTypeRegistry.getInstance().getNodeTypes(jahiaTemplatesPackage.getId());
            while (jahiaNodeTypeIterator.hasNext()) {
                ExtendedNodeType extendedNodeType = (ExtendedNodeType)jahiaNodeTypeIterator.nextNodeType();
                if (!NodeTypesUtils.isValidNodeType(extendedNodeType, nodeTypes, excludedNodeTypes, includeSubTypes, site)) continue;
                types.add(extendedNodeType);
            }
            if (!jahiaTemplatesPackage.isDefault()) continue;
            NodeTypeRegistry.JahiaNodeTypeIterator jahiaNodeTypeIterator2 = NodeTypeRegistry.getInstance().getNodeTypes("system-jahia");
            while (jahiaNodeTypeIterator2.hasNext()) {
                ExtendedNodeType extendedNodeType = (ExtendedNodeType)jahiaNodeTypeIterator2.nextNodeType();
                if (!NodeTypesUtils.isValidNodeType(extendedNodeType, nodeTypes, excludedNodeTypes, includeSubTypes, site)) continue;
                types.add(extendedNodeType);
            }
        }
        HashMap r = new HashMap();
        for (ExtendedNodeType extendedNodeType : types) {
            if (extendedNodeType.isMixin() || extendedNodeType.isAbstract()) continue;
            ExtendedNodeType extendedNodeType2 = NodeTypesUtils.findFolder(extendedNodeType);
            if (!r.containsKey(extendedNodeType2)) {
                r.put(extendedNodeType2, new ArrayList());
            }
            ((List)r.get(extendedNodeType2)).add(extendedNodeType);
        }
        TreeSet<NodeTypeTreeEntry> treeSet = new TreeSet<NodeTypeTreeEntry>();
        for (Map.Entry entry : r.entrySet()) {
            ExtendedNodeType entryType = entry.getKey() != null ? (ExtendedNodeType)entry.getKey() : NodeTypeRegistry.getInstance().getNodeType("nt:base");
            NodeTypeTreeEntry nt = new NodeTypeTreeEntry(entryType, uiLocale);
            treeSet.add(nt);
            ArrayList<NodeTypeTreeEntry> children = new ArrayList<NodeTypeTreeEntry>(((List)entry.getValue()).size());
            for (ExtendedNodeType extendedNodeType : (List)entry.getValue()) {
                children.add(new NodeTypeTreeEntry(extendedNodeType, uiLocale));
            }
            NodeTypesUtils.disambiguateLabels(children);
            for (NodeTypeTreeEntry nodeTypeTreeEntry2 : children) {
                nt.add(nodeTypeTreeEntry2);
            }
        }
        if (treeSet.size() == 1 && ((nodeTypeTreeEntry = (NodeTypeTreeEntry)treeSet.iterator().next()).getNodeType().isMixin() || nodeTypeTreeEntry.getName().equals("nt:base"))) {
            Set<NodeTypeTreeEntry> set = nodeTypeTreeEntry.getChildren();
            treeSet.clear();
            treeSet.addAll(set);
        }
        return treeSet;
    }

    public static boolean checkPermissionForType(String typename, JCRNodeWrapper node) throws RepositoryException {
        ExtendedNodeType type = NodeTypeRegistry.getInstance().getNodeType(typename);
        return NodeTypesUtils.checkPermissionForType(type, node);
    }

    private static Collection<NodeTypeTreeEntry> disambiguateLabels(Collection<NodeTypeTreeEntry> nodeTypes) {
        List ambiguousNodeTypes = nodeTypes.stream().collect(Collectors.groupingBy(NodeTypeTreeEntry::getLabel)).values().stream().filter(l -> l.size() > 1).flatMap(Collection::stream).collect(Collectors.toList());
        for (NodeTypeTreeEntry nodeType : ambiguousNodeTypes) {
            nodeType.setLabel(nodeType.getLabel() + " (" + nodeType.getName() + ")");
        }
        return nodeTypes;
    }

    private static ExtendedNodeType findFolder(ExtendedNodeType nt) {
        if (!"jmix:droppableContent".equals(nt.getName()) && nt.isNodeType("jmix:droppableContent")) {
            if (logger.isDebugEnabled()) {
                logger.debug("Detected component type {}", (Object)nt.getName());
            }
            ExtendedNodeType[] supertypes = nt.getSupertypes();
            for (int i = supertypes.length - 1; i >= 0; --i) {
                ExtendedNodeType st = supertypes[i];
                if (!st.isMixin() || st.getName().equals("jmix:droppableContent") || !st.isNodeType("jmix:droppableContent")) continue;
                return st;
            }
        }
        return null;
    }

    private static boolean isValidNodeType(ExtendedNodeType ent, List<String> nodeTypes, List<String> excludedNodeTypes, boolean includeSubTypes, JCRNodeWrapper node) throws RepositoryException {
        if (ent == null) {
            return false;
        }
        if (includeSubTypes) {
            if (NodeTypesUtils.isNodeType(nodeTypes, ent) && NodeTypesUtils.checkPermissionForType(ent, node)) {
                return excludedNodeTypes == null || !NodeTypesUtils.isNodeType(excludedNodeTypes, ent);
            }
        } else {
            if (nodeTypes == null) {
                return false;
            }
            for (String nodeType : nodeTypes) {
                if (!ent.getName().equals(nodeType) || !NodeTypesUtils.checkPermissionForType(ent, node)) continue;
                return excludedNodeTypes == null || !NodeTypesUtils.isNodeType(excludedNodeTypes, ent);
            }
        }
        return false;
    }

    private static boolean checkPermissionForType(ExtendedNodeType type, JCRNodeWrapper node) throws NoSuchNodeTypeException {
        ExtendedNodeType[] supertypesArray = type.getSupertypes();
        if (supertypesArray.length == 0) {
            return true;
        }
        HashSet<ExtendedNodeType> superTypes = new HashSet<ExtendedNodeType>(supertypesArray.length);
        superTypes.addAll(Arrays.asList(supertypesArray));
        NodeTypeIterator it = NodeTypeRegistry.getInstance().getNodeType("jmix:accessControllableContent").getDeclaredSubtypes();
        boolean allowed = true;
        while (it.hasNext()) {
            ExtendedNodeType next = (ExtendedNodeType)it.next();
            if (!superTypes.contains(next)) continue;
            allowed = node.hasPermission("component-" + next.getName().replace(":", "_"));
        }
        return allowed;
    }

    private static boolean isNodeType(List<String> nodeTypes, ExtendedNodeType type) {
        if (nodeTypes != null) {
            for (String nodeType : nodeTypes) {
                if (!type.isNodeType(nodeType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

