/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.patches;

import javax.servlet.Servlet;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.tools.patches.PatchExecutor;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlPatcher
implements PatchExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GraphqlPatcher.class);
    private static final int TIMEOUT = 60000;

    @Override
    public boolean canExecute(String name, String lifecyclePhase) {
        return name.endsWith(lifecyclePhase + ".graphql");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeScript(String name, String scriptContent) {
        try {
            BundleContext context = FrameworkService.getBundleContext();
            Filter filter = context.createFilter("(component.name=graphql.kickstart.servlet.OsgiGraphQLHttpServlet)");
            ServiceTracker configurationAdminTracker = new ServiceTracker(context, filter, null);
            configurationAdminTracker.open();
            Servlet servlet = (Servlet)configurationAdminTracker.waitForService(60000L);
            configurationAdminTracker.close();
            if (servlet == null) {
                logger.error("Cannot find OSGi graphql servlet to execute patch");
                String string = ".failed";
                return string;
            }
            JCRSessionFactory.getInstance().setCurrentUser(JahiaUserManagerService.getInstance().lookupRootUser().getJahiaUser());
            String json = (String)servlet.getClass().getMethod("executeQuery", String.class).invoke((Object)servlet, scriptContent);
            logger.info("Graphql execution result : {}", (Object)json);
            JSONObject object = new JSONObject(json);
            if (object.has("errors") && object.getJSONArray("errors").length() > 0) {
                String string = ".failed";
                return string;
            }
            String string = ".installed";
            return string;
        }
        catch (Exception e) {
            logger.error("Execution of script failed with error: {}", (Object)e.getMessage(), (Object)e);
            String string = ".failed";
            return string;
        }
        finally {
            JCRSessionFactory.getInstance().setCurrentUser(null);
        }
    }
}

