/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.settings;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jahia.settings.EnvironmentVariablesPropertiesFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertiesFactoryBean;

public class SystemPropertiesFactoryBean
extends PropertiesFactoryBean {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentVariablesPropertiesFactoryBean.class);
    private String prefix;

    protected Properties createProperties() throws IOException {
        Properties props = new Properties();
        Properties sysProps = System.getProperties();
        for (Object keyObj : sysProps.keySet()) {
            String value;
            String key = keyObj.toString();
            if (!StringUtils.isNotEmpty((String)this.prefix) || !key.startsWith(this.prefix) || (value = sysProps.getProperty(key)) == null) continue;
            props.put(StringUtils.substringAfter((String)key, (String)this.prefix), value);
        }
        logger.info("Detected the following system properties, which will be considered in the configuration: {}", (Object)props.keySet().toArray());
        return props;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

