/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.settings;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.jahia.settings.SettingsBean;
import org.jahia.settings.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JahiaPropertiesUtils {
    public static final Charset CHARSET = Charset.forName(System.getProperty("jahia.properties.charset", "UTF-8"));
    private static final Logger logger = LoggerFactory.getLogger(JahiaPropertiesUtils.class);

    private JahiaPropertiesUtils() {
    }

    public static final void addEntry(String key, String value, String comment, String afterLinePattern, File jahiaPropertiesFile) throws IOException {
        Pattern pattern;
        String afterLineMatch;
        List lines = FileUtils.readLines((File)jahiaPropertiesFile, (Charset)CHARSET);
        if (JahiaPropertiesUtils.getPropertyLine(key, lines) != null || JahiaPropertiesUtils.getCommentedPropertyLine(key, lines) != null) {
            return;
        }
        int insertPosition = lines.size();
        if (afterLinePattern != null && (afterLineMatch = (String)CollectionUtils.find((Collection)lines, arg_0 -> JahiaPropertiesUtils.lambda$addEntry$0(pattern = Pattern.compile(afterLinePattern), arg_0))) != null) {
            insertPosition = lines.indexOf(afterLineMatch) + 1;
        }
        ArrayList<String> toBeAdded = new ArrayList<String>();
        if (insertPosition == lines.size()) {
            toBeAdded.add("");
        }
        if (comment != null) {
            String[] commentLines;
            for (String commentLine : commentLines = StringUtils.split(comment, "\n")) {
                if (" ".equals(commentLine)) {
                    toBeAdded.add("");
                    continue;
                }
                if (commentLine.length() == 0 || commentLine.charAt(0) != '#') {
                    toBeAdded.add("# " + commentLine);
                    continue;
                }
                toBeAdded.add(commentLine);
            }
        }
        toBeAdded.add(key + " = " + value);
        for (int i = toBeAdded.size() - 1; i >= 0; --i) {
            lines.add(insertPosition, toBeAdded.get(i));
        }
        FileUtils.writeLines((File)jahiaPropertiesFile, (String)CHARSET.name(), (Collection)lines);
    }

    public static void removeEntry(RemoveOperation[] operations) throws IOException {
        File cfg = JahiaPropertiesUtils.detectJahiaPropertiesFile();
        if (cfg == null) {
            JahiaPropertiesUtils.jahiaPropertiesFileNotFound();
            for (RemoveOperation operation : operations) {
                operation.logError();
            }
            return;
        }
        List innerlines = FileUtils.readLines((File)cfg, (Charset)CHARSET);
        ArrayList<RemoveOperation> failedOperations = new ArrayList<RemoveOperation>();
        for (RemoveOperation operation : operations) {
            boolean success = false;
            if (operation == null || operation.getPattern() == null || operation.getPattern().length == 0) continue;
            if (operation.getType().equals((Object)RemoveOperation.Type.EXACT_BLOCK)) {
                int startIndex = JahiaPropertiesUtils.findInLines(innerlines, operation.getPattern()[0], 0);
                boolean blockFound = false;
                while (startIndex != -1 && !blockFound) {
                    if (startIndex + operation.getPattern().length <= innerlines.size()) {
                        boolean goToNext = false;
                        for (int i = 1; i < operation.getPattern().length; ++i) {
                            String subLine = operation.getPattern()[i];
                            if (((String)innerlines.get(startIndex + i)).equals(subLine)) continue;
                            goToNext = true;
                            break;
                        }
                        if (goToNext) {
                            startIndex = JahiaPropertiesUtils.findInLines(innerlines, operation.getPattern()[0], startIndex);
                            continue;
                        }
                        blockFound = true;
                        continue;
                    }
                    startIndex = JahiaPropertiesUtils.findInLines(innerlines, operation.getPattern()[0], startIndex);
                }
                if (blockFound) {
                    for (int i = operation.getPattern().length - 1; i >= 0; --i) {
                        innerlines.remove(startIndex + i);
                    }
                    success = true;
                } else {
                    failedOperations.add(operation);
                }
            } else if (operation.getType().equals((Object)RemoveOperation.Type.REGEXP_LINE)) {
                Pattern pattern = Pattern.compile(operation.getPattern()[0]);
                int deletePosition = -1;
                String afterLineMatch = (String)CollectionUtils.find((Collection)innerlines, line -> pattern.matcher((String)line).matches());
                if (afterLineMatch != null) {
                    deletePosition = innerlines.indexOf(afterLineMatch) + 1;
                }
                if (deletePosition != -1) {
                    innerlines.remove(deletePosition - 1);
                    success = true;
                } else {
                    failedOperations.add(operation);
                }
            }
            if (!success) continue;
            logger.info("Removed entry {} from {}", (Object)operation.concernedProperty, (Object)cfg);
        }
        if (!failedOperations.isEmpty()) {
            for (RemoveOperation operation : failedOperations) {
                operation.logError();
            }
        }
        FileUtils.writeLines((File)cfg, (String)CHARSET.name(), (Collection)innerlines);
    }

    public static void replace(String searchString, String replacement) throws IOException {
        File cfg = JahiaPropertiesUtils.detectJahiaPropertiesFile();
        if (cfg == null) {
            JahiaPropertiesUtils.jahiaPropertiesFileNotFound();
            return;
        }
        String content = FileUtils.readFileToString((File)cfg, (Charset)CHARSET);
        String modifiedContent = StringUtils.replaceAllTokens(content, searchString, replacement);
        if (!modifiedContent.equals(content)) {
            logger.info("Replaced in {} occurrences of the {} with {}", new Object[]{cfg.getCanonicalPath(), searchString, replacement});
            FileUtils.writeStringToFile((File)cfg, (String)modifiedContent, (String)CHARSET.name());
        }
    }

    private static int findInLines(List<String> lines, String lineToFind, int startIndex) {
        for (int i = 0; i < lines.size(); ++i) {
            String line;
            if (i <= startIndex || !(line = lines.get(i)).equals(lineToFind)) continue;
            return i;
        }
        return -1;
    }

    public static final void addEntry(String key, String value, String comment, String afterLinePattern, String error) throws IOException {
        File cfg = JahiaPropertiesUtils.detectJahiaPropertiesFile();
        if (cfg != null) {
            JahiaPropertiesUtils.addEntry(key, value, comment, afterLinePattern, cfg);
            logger.info("Added entry {} into {}", (Object)key, (Object)cfg);
        } else {
            JahiaPropertiesUtils.jahiaPropertiesFileNotFound();
            logger.info(error);
        }
    }

    public static final void uncommentOrAddEntryIfMissing(String key, String defaultValue) throws IOException {
        File cfg = JahiaPropertiesUtils.detectJahiaPropertiesFile();
        if (cfg == null) {
            JahiaPropertiesUtils.jahiaPropertiesFileNotFound();
            return;
        }
        List lines = FileUtils.readLines((File)cfg, (Charset)CHARSET);
        String configured = JahiaPropertiesUtils.getPropertyLine(key, lines);
        if (configured != null) {
            return;
        }
        String commented = JahiaPropertiesUtils.getCommentedPropertyLine(key, lines);
        if (commented == null) {
            lines.add("");
            lines.add(key + " = " + defaultValue);
        } else {
            int index = JahiaPropertiesUtils.findInLines(lines, commented, 0);
            if (commented.endsWith(defaultValue)) {
                lines.remove(index);
                lines.add(index, key + " = " + defaultValue);
            } else {
                lines.add(index + 1, key + " = " + defaultValue);
            }
        }
        FileUtils.writeLines((File)cfg, (Collection)lines);
        logger.info("Added entry {} into {}", (Object)key, (Object)cfg);
    }

    public static String getPropertyLine(String key, List<String> lines) {
        Pattern patternConfigured = Pattern.compile("^[ \\t]*" + Pattern.quote(key) + "[ \\t]*[=:][ \\t]*\\S+$", 8);
        return (String)CollectionUtils.find(lines, line -> patternConfigured.matcher((String)line).matches());
    }

    public static String getCommentedPropertyLine(String key, List<String> lines) {
        Pattern patternConfigured = Pattern.compile("^[ \\t]*[#!]+[ \\t]*" + Pattern.quote(key) + "[ \\t]*[=:][ \\t]*\\S+$", 8);
        return (String)CollectionUtils.find(lines, line -> patternConfigured.matcher((String)line).matches());
    }

    public static void jahiaPropertiesFileNotFound() {
        logger.warn("The fix applier cannot detect the location of the jahia.properties file");
    }

    public static File detectJahiaPropertiesFile() throws IOException {
        File propFile;
        Resource[] resources = SettingsBean.getInstance().getApplicationContext().getResources("classpath*:jahia/jahia.properties");
        Optional<Resource> resource = Arrays.stream(resources).findFirst();
        if (resource.isPresent() && (propFile = resource.get().getFile()).exists()) {
            return propFile.getCanonicalFile();
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$addEntry$0(Pattern pattern, Object line) {
        return pattern.matcher((String)line).matches();
    }

    public static class RemoveOperation {
        private String[] pattern;
        private Type type;
        private String concernedProperty;

        public RemoveOperation(String concernedProperty, Type type, String ... pattern) {
            this.concernedProperty = concernedProperty;
            this.pattern = pattern;
            this.type = type;
        }

        public void logError() {
            logger.info("[WARNING] The fix applier failed to remove (comments and/or property) from jahia.properties");
            logger.info("The concerned deprecated property is: {}", (Object)this.concernedProperty);
            logger.info("It could be that the property no longer exists or requires manual removal. Verify by looking at the following line(s) from your jahia.properties file:");
            if (this.type.equals((Object)Type.EXACT_BLOCK)) {
                logger.info("-- START --");
                for (String line : this.pattern) {
                    logger.info(line);
                }
                logger.info("-- END --");
            } else if (this.type.equals((Object)Type.REGEXP_LINE)) {
                logger.info("Regexp: {}", (Object)this.pattern[0]);
            }
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String[] getPattern() {
            return this.pattern;
        }

        public void setPattern(String[] pattern) {
            this.pattern = pattern;
        }

        public static enum Type {
            EXACT_BLOCK,
            REGEXP_LINE;

        }
    }
}

