/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.custom.email;

import java.io.File;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.jcr.RepositoryException;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.velocity.tools.generic.DateTool;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.bin.Jahia;
import org.jahia.data.viewhelper.principal.PrincipalViewHelper;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.PublicationInfo;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.preferences.user.UserPreferencesHelper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaPrincipal;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowComment;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowVariable;
import org.jahia.services.workflow.jbpm.JBPMTaskIdentityService;
import org.jahia.services.workflow.jbpm.custom.email.AddressTemplate;
import org.jahia.services.workflow.jbpm.custom.email.AttachmentTemplate;
import org.jahia.services.workflow.jbpm.custom.email.MailTemplate;
import org.jahia.services.workflow.jbpm.custom.email.MailTemplateRegistry;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.ScriptEngineUtils;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.i18n.ResourceBundles;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskIdentityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPMMailProducer {
    private static final Logger logger = LoggerFactory.getLogger(JBPMMailProducer.class);
    private static final Pattern ACTORS_PATTERN = Pattern.compile("(assignableFor\\([^)]+\\))|([^,;\\s]+)");
    public static final String CUSTOM_WORKFLOW_INFO = "customWorkflowInfo";
    protected ScriptEngine scriptEngine;
    protected Bindings bindings;
    protected WorkflowService workflowService;
    protected MailTemplateRegistry mailTemplateRegistry;
    protected TaskIdentityService taskIdentityService;
    protected JahiaUserManagerService userManagerService;
    protected JahiaGroupManagerService groupManagerService;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setMailTemplateRegistry(MailTemplateRegistry mailTemplateRegistry) {
        this.mailTemplateRegistry = mailTemplateRegistry;
    }

    public void setTaskIdentityService(TaskIdentityService taskIdentityService) {
        this.taskIdentityService = taskIdentityService;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    public void setGroupManagerService(JahiaGroupManagerService groupManagerService) {
        this.groupManagerService = groupManagerService;
    }

    public Collection<Message> produce(final WorkItem workItem) {
        if (!ServicesRegistry.getInstance().getMailService().isEnabled()) {
            return Collections.emptyList();
        }
        Map vars = workItem.getParameters();
        Locale locale = (Locale)vars.get("locale");
        String templateKey = (String)vars.get("templateKey");
        MailTemplate template = null;
        if (templateKey != null) {
            if (locale != null && (template = this.mailTemplateRegistry.getTemplate(templateKey + "." + locale.toString())) == null) {
                template = this.mailTemplateRegistry.getTemplate(templateKey + "." + locale.getLanguage());
            }
            if (template == null) {
                template = this.mailTemplateRegistry.getTemplate(templateKey);
            }
        }
        if (template != null) {
            final MailTemplate usedTemplate = template;
            try {
                return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "default", locale, new JCRCallback<Collection<Message>>(){

                    @Override
                    public Collection<Message> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        try {
                            JBPMMailProducer.this.scriptEngine = ScriptEngineUtils.getInstance().getEngineByName(usedTemplate.getLanguage());
                            JBPMMailProducer.this.bindings = null;
                            Message email = JBPMMailProducer.this.instantiateEmail();
                            JBPMMailProducer.this.fillFrom(usedTemplate, email, workItem, session);
                            JBPMMailProducer.this.fillRecipients(usedTemplate, email, workItem, session);
                            JBPMMailProducer.this.fillSubject(usedTemplate, email, workItem, session);
                            JBPMMailProducer.this.fillContent(usedTemplate, email, workItem, session);
                            Address[] addresses = email.getRecipients(Message.RecipientType.TO);
                            if (addresses != null && addresses.length > 0) {
                                return Collections.singleton(email);
                            }
                            addresses = email.getRecipients(Message.RecipientType.BCC);
                            if (addresses != null && addresses.length > 0) {
                                return Collections.singleton(email);
                            }
                            addresses = email.getRecipients(Message.RecipientType.CC);
                            if (addresses != null && addresses.length > 0) {
                                return Collections.singleton(email);
                            }
                            return Collections.emptyList();
                        }
                        catch (Exception e) {
                            logger.error("Cannot produce mail", (Throwable)e);
                            return Collections.emptyList();
                        }
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error("Cannot produce mail", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    protected Message instantiateEmail() {
        return new MimeMessage((Session)null);
    }

    protected void fillFrom(MailTemplate template, Message email, WorkItem workItem, JCRSessionWrapper session) throws Exception {
        String groupList;
        String userList;
        AddressTemplate fromTemplate = template.getFrom();
        if (fromTemplate == null) {
            return;
        }
        String addresses = fromTemplate.getAddresses();
        if (addresses != null) {
            addresses = this.evaluateExpression(workItem, addresses, session);
            email.addFrom((Address[])InternetAddress.parse((String)addresses, (boolean)false));
        }
        if ((userList = fromTemplate.getUsers()) != null) {
            String[] userIds = this.tokenizeActors(userList, workItem, session);
            ArrayList<User> users = new ArrayList<User>();
            String[] stringArray = userIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String userId = stringArray[i];
                users.add(this.taskIdentityService.getUserById(userId));
            }
            email.addFrom(this.getAddresses(users));
        }
        if ((groupList = fromTemplate.getGroups()) != null) {
            for (String groupId : this.tokenizeActors(groupList, workItem, session)) {
                Group group = this.taskIdentityService.getGroupById(groupId);
                email.addFrom(this.getAddresses(group));
            }
        }
    }

    protected void fillRecipients(MailTemplate template, Message email, WorkItem workItem, JCRSessionWrapper session) throws Exception {
        AddressTemplate bcc;
        AddressTemplate cc;
        AddressTemplate to = template.getTo();
        if (to != null) {
            this.fillRecipients(to, email, Message.RecipientType.TO, workItem, session);
        }
        if ((cc = template.getCc()) != null) {
            this.fillRecipients(cc, email, Message.RecipientType.CC, workItem, session);
        }
        if ((bcc = template.getBcc()) != null) {
            this.fillRecipients(bcc, email, Message.RecipientType.BCC, workItem, session);
        }
    }

    protected void fillRecipients(AddressTemplate addressTemplate, Message email, Message.RecipientType recipientType, WorkItem workItem, JCRSessionWrapper session) throws Exception {
        String groupList;
        String userList;
        LinkedHashSet recipients = new LinkedHashSet();
        String addresses = addressTemplate.getAddresses();
        if (addresses != null) {
            addresses = this.evaluateExpression(workItem, addresses, session);
            Collections.addAll(recipients, InternetAddress.parse((String)addresses, (boolean)false));
        }
        if ((userList = addressTemplate.getUsers()) != null) {
            String[] userIds = this.tokenizeActors(userList, workItem, session);
            ArrayList<User> users = new ArrayList<User>();
            String[] stringArray = userIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String userId = stringArray[i];
                if (userId.startsWith("assignableFor(")) {
                    String task = StringUtils.substringBetween((String)userId, (String)"assignableFor(", (String)")");
                    WorkflowDefinition definition = this.workflowService.getWorkflow("jBPM", Long.toString(workItem.getProcessInstanceId()), null).getWorkflowDefinition();
                    List<JahiaPrincipal> principals = this.workflowService.getAssignedRole(definition, task, Long.toString(workItem.getProcessInstanceId()), session);
                    for (JahiaPrincipal principal : principals) {
                        JCRGroupNode groupNode;
                        if (principal instanceof JahiaUser) {
                            if (UserPreferencesHelper.areEmailNotificationsDisabled((JahiaUser)principal)) continue;
                            users.add(this.taskIdentityService.getUserById(((JahiaUser)principal).getUserKey()));
                            continue;
                        }
                        if (!(principal instanceof JahiaGroup) || (groupNode = this.groupManagerService.lookupGroupByPath(principal.getLocalPath())) == null) continue;
                        for (JCRUserNode user : groupNode.getRecursiveUserMembers()) {
                            if (UserPreferencesHelper.areEmailNotificationsDisabled(user)) continue;
                            users.add(this.taskIdentityService.getUserById(user.getPath()));
                        }
                    }
                    continue;
                }
                User userById = this.taskIdentityService.getUserById(userId);
                if (!(userById instanceof JBPMTaskIdentityService.UserImpl) || ((JBPMTaskIdentityService.UserImpl)userById).areEmailNotificationsDisabled()) continue;
                users.add(userById);
            }
            Collections.addAll(recipients, this.getAddresses(users));
        }
        if ((groupList = addressTemplate.getGroups()) != null) {
            for (String groupId : this.tokenizeActors(groupList, workItem, session)) {
                Group group = this.taskIdentityService.getGroupById(groupId);
                Collections.addAll(recipients, this.getAddresses(group));
            }
        }
        email.addRecipients(recipientType, recipients.toArray(new Address[recipients.size()]));
    }

    protected String[] tokenizeActors(String recipients, WorkItem workItem, JCRSessionWrapper session) throws Exception {
        ArrayList<String> actors = new ArrayList<String>();
        Matcher m = ACTORS_PATTERN.matcher(recipients);
        while (m.find()) {
            actors.add(m.group());
        }
        return actors.toArray(new String[actors.size()]);
    }

    protected Address[] getAddresses(List<User> users) {
        int userCount = users.size();
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (int i = 0; i < userCount; ++i) {
            Address userAddress = null;
            try {
                userAddress = this.getAddress(users.get(i));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Error retrieving email address for user " + users.get(i), (Throwable)e);
            }
            if (userAddress == null) continue;
            addresses.add(userAddress);
        }
        return addresses.toArray(new Address[addresses.size()]);
    }

    protected Address[] getAddresses(Group group) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        JCRGroupNode jahiaGroup = JahiaGroupManagerService.getInstance().lookupGroupByPath(group.getId());
        if (jahiaGroup == null) {
            return new Address[0];
        }
        Set<JCRUserNode> recursiveUsers = jahiaGroup.getRecursiveUserMembers();
        for (JCRUserNode user : recursiveUsers) {
            if (UserPreferencesHelper.areEmailNotificationsDisabled(user)) continue;
            Address address = null;
            try {
                address = this.getAddress(user.getPropertyAsString("j:firstName"), user.getPropertyAsString("j:lastName"), user.getPropertyAsString("j:email"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Error while trying to get email address for user " + user, (Throwable)e);
                address = null;
            }
            if (address == null) continue;
            addresses.add(address);
        }
        return addresses.toArray(new Address[addresses.size()]);
    }

    protected Address getAddress(User user) throws UnsupportedEncodingException {
        if (user instanceof JBPMTaskIdentityService.UserImpl) {
            JBPMTaskIdentityService.UserImpl userImpl = (JBPMTaskIdentityService.UserImpl)user;
            return this.getAddress(userImpl.getGivenName(), userImpl.getFamilyName(), userImpl.getBusinessEmail());
        }
        return null;
    }

    protected Address getAddress(String firstName, String lastName, String email) throws UnsupportedEncodingException {
        String personal = null;
        if (StringUtils.isEmpty((String)email)) {
            return null;
        }
        personal = StringUtils.isNotEmpty((String)firstName) && StringUtils.isNotEmpty((String)lastName) ? firstName + " " + lastName : (StringUtils.isEmpty((String)firstName) && StringUtils.isEmpty((String)lastName) ? null : (StringUtils.isEmpty((String)firstName) ? lastName : firstName));
        return new InternetAddress(email, personal, "UTF-8");
    }

    protected void fillSubject(MailTemplate template, Message email, WorkItem workItem, JCRSessionWrapper session) throws Exception {
        String subject = template.getSubject();
        if (subject != null) {
            String evaluatedSubject = this.evaluateExpression(workItem, subject, session).replaceAll("[\r\n]", "");
            email.setHeader("Subject", WordUtils.abbreviate((String)evaluatedSubject, (int)60, (int)74, (String)"..."));
        }
    }

    protected void fillContent(MailTemplate template, Message email, WorkItem workItem, JCRSessionWrapper session) throws Exception {
        String text = template.getText();
        String html = template.getHtml();
        List<AttachmentTemplate> attachmentTemplates = template.getAttachmentTemplates();
        if (html != null || !attachmentTemplates.isEmpty()) {
            MimeMultipart multipart = new MimeMultipart("related");
            MimeBodyPart p = new MimeBodyPart();
            MimeMultipart alternatives = new MimeMultipart("alternative");
            p.setContent((Object)alternatives, "multipart/alternative");
            multipart.addBodyPart((BodyPart)p);
            if (html != null) {
                MimeBodyPart htmlPart = new MimeBodyPart();
                html = this.evaluateExpression(workItem, html, session);
                htmlPart.setContent((Object)html, "text/html; charset=UTF-8");
                alternatives.addBodyPart((BodyPart)htmlPart);
            }
            if (text != null) {
                MimeBodyPart textPart = new MimeBodyPart();
                text = this.evaluateExpression(workItem, text, session);
                textPart.setContent((Object)text, "text/plain; charset=UTF-8");
                alternatives.addBodyPart((BodyPart)textPart);
            }
            if (!attachmentTemplates.isEmpty()) {
                this.addAttachments(template, workItem, (Multipart)multipart, session);
            }
            email.setContent((Multipart)multipart);
        } else if (text != null) {
            text = this.evaluateExpression(workItem, text, session);
            email.setText(text);
        }
    }

    protected String evaluateExpression(WorkItem workItem, String scriptToExecute, JCRSessionWrapper session) throws RepositoryException, ScriptException {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        if (this.bindings == null) {
            this.bindings = this.getBindings(workItem, session);
        }
        this.addStaticClasses(this.bindings);
        scriptContext.setWriter(new StringWriter());
        scriptContext.setErrorWriter(new StringWriter());
        scriptContext.setBindings(this.bindings, 100);
        scriptContext.setBindings(scriptContext.getBindings(200), 200);
        this.scriptEngine.eval(scriptToExecute, (ScriptContext)scriptContext);
        String error = scriptContext.getErrorWriter().toString();
        if (error.length() > 0) {
            logger.error("Scripting error : " + error);
        }
        return scriptContext.getWriter().toString().trim();
    }

    protected void addStaticClasses(Bindings bindings) {
        if (bindings != null) {
            bindings.put("PrincipalViewHelper", (Object)PrincipalViewHelper.class);
        }
    }

    protected Bindings getBindings(WorkItem workItem, JCRSessionWrapper session) throws RepositoryException {
        Map vars = workItem.getParameters();
        Locale locale = (Locale)vars.get("locale");
        MyBindings bindings = new MyBindings(workItem);
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)vars.get("workflow");
        ResourceBundle resourceBundle = ResourceBundles.get(workflowDefinition.getPackageName() + "." + workflowDefinition.getName(), locale);
        bindings.put("bundle", (Object)resourceBundle);
        JCRUserNode jahiaUser = this.userManagerService.lookupUserByPath((String)vars.get("user"));
        if (vars.containsKey("currentUser")) {
            JCRUserNode currentUser = this.userManagerService.lookupUserByPath((String)vars.get("currentUser"));
            bindings.put("currentUser", (Object)currentUser);
        } else {
            bindings.put("currentUser", (Object)jahiaUser);
        }
        bindings.put("user", (Object)jahiaUser);
        if (jahiaUser != null && !UserPreferencesHelper.areEmailNotificationsDisabled(jahiaUser)) {
            bindings.put("userNotificationEmail", (Object)UserPreferencesHelper.getPersonalizedEmailAddress(jahiaUser));
        }
        bindings.put("date", (Object)new DateTool());
        bindings.put("submissionDate", (Object)Calendar.getInstance());
        bindings.put("locale", (Object)locale);
        bindings.put("workspace", vars.get("workspace"));
        bindings.put("workflow", (Object)workflowDefinition);
        Workflow workflow = this.workflowService.getWorkflow(workflowDefinition.getProvider(), String.valueOf(workItem.getProcessInstanceId()), locale);
        if (workflow != null) {
            this.processPublicationWorkFlow(session, workflowDefinition, workflow, bindings, locale);
            this.processWorkflowComments(workflow, bindings);
        }
        String contextPath = Jahia.getContextPath();
        bindings.put("contextPath", (Object)contextPath);
        JCRSiteNode siteNode = null;
        LinkedList<JCRNodeWrapper> nodes = new LinkedList<JCRNodeWrapper>();
        List stringList = (List)vars.get("nodeIds");
        for (String s : stringList.size() > 10 ? stringList.subList(0, 9) : stringList) {
            JCRNodeWrapper nodeByUUID = session.getNodeByUUID(s);
            if (nodeByUUID.isNodeType("jnt:translation")) continue;
            if (siteNode == null) {
                siteNode = nodeByUUID.getResolveSite();
            }
            nodes.add(nodeByUUID);
        }
        bindings.put("nodes", (Object)nodes);
        if (siteNode != null) {
            int siteURLPortOverride = SettingsBean.getInstance().getSiteURLPortOverride();
            String servername = "http" + (siteURLPortOverride == 443 ? "s" : "") + "://" + siteNode.getServerName() + (siteURLPortOverride != 0 && siteURLPortOverride != 80 && siteURLPortOverride != 443 ? ":" + siteURLPortOverride : "");
            bindings.put("site", (Object)siteNode);
            bindings.put("servername", (Object)servername);
            bindings.put("previewPrefix", (Object)String.format("%s%s/cms/render/%s/%s", servername, contextPath, "default", locale));
            bindings.put("editPrefix", (Object)String.format("%s%s/jahia/page-composer/%s/%s", servername, contextPath, "default", locale));
            bindings.put("cmmPrefix", (Object)String.format("%s%s/jahia/jcontent/%s/%s", servername, contextPath, siteNode.getSiteKey(), locale));
            bindings.put("renderContext", (Object)new RenderContext(null, null, JCRSessionFactory.getInstance().getCurrentUser()));
        }
        return bindings;
    }

    private void processPublicationWorkFlow(JCRSessionWrapper session, WorkflowDefinition workflowDefinition, Workflow workflow, Bindings bindings, Locale locale) throws RepositoryException {
        Map<String, Object> variables = workflow.getVariables();
        if (variables.containsKey(CUSTOM_WORKFLOW_INFO) && variables.get(CUSTOM_WORKFLOW_INFO) instanceof PublicationWorkflow) {
            PublicationWorkflow publicationWorkflow = (PublicationWorkflow)variables.get(CUSTOM_WORKFLOW_INFO);
            List<GWTJahiaPublicationInfo> publicationInfoList = publicationWorkflow.getPublicationInfos();
            int publicationCount = publicationInfoList.size();
            bindings.put("publicationCount", (Object)publicationCount);
            JCRUserNode workflowUser = this.userManagerService.lookupUserByPath(workflow.getStartUser());
            String workflowUserName = workflowUser != null ? PrincipalViewHelper.getFullName(workflowUser) : "";
            DateTool dateTool = new DateTool();
            String workflowTitle = String.format("%s - %s started by %s on %s - %d content item(s) involved", locale, workflowDefinition.getDisplayName(), workflowUserName, dateTool.format("short_date", (Object)workflow.getStartTime(), locale), publicationCount);
            if (variables.containsKey("jcr_title")) {
                workflowTitle = ((WorkflowVariable)variables.get("jcr_title")).getValue();
            }
            bindings.put("workflowTitle", (Object)workflowTitle);
            if (publicationCount > 10) {
                publicationInfoList = publicationInfoList.subList(0, 9);
            }
            bindings.put("publications", (Object)this.processPublicationInfoList(session, locale, publicationInfoList));
        }
    }

    private Map<String, List<Map<String, Object>>> processPublicationInfoList(JCRSessionWrapper session, Locale locale, List<GWTJahiaPublicationInfo> publicationInfoList) throws RepositoryException {
        LinkedHashMap<String, List<Map<String, Object>>> publications = new LinkedHashMap<String, List<Map<String, Object>>>();
        this.initPublicationsMap(publications, locale);
        for (GWTJahiaPublicationInfo publicationInfo : publicationInfoList) {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("status", publicationInfo.getStatus());
            if (publicationInfo.getStatus() == 11) {
                node.put("path", publicationInfo.getPath());
                node.put("type", publicationInfo.getNodetype());
                String displayableName = publicationInfo.getTitle();
                if (displayableName.length() > 100) {
                    displayableName = String.format("%s...", displayableName.substring(0, 100));
                }
                node.put("displayableName", displayableName);
                ((List)publications.get(this.getPublicationLabelI18N(publicationInfo.getStatus(), locale))).add(node);
                continue;
            }
            JCRNodeWrapper nodeByUUID = session.getNodeByUUID(publicationInfo.getUuid());
            node.put("node", nodeByUUID);
            node.put("path", publicationInfo.getPath());
            node.put("type", publicationInfo.getNodetype());
            String displayableName = nodeByUUID.getDisplayableName();
            if (displayableName.length() > 100) {
                displayableName = String.format("%s...", displayableName.substring(0, 100));
            }
            node.put("displayableName", displayableName);
            node.put("displayablePath", publicationInfo.getMainPath());
            ((List)publications.get(this.getPublicationLabelI18N(publicationInfo.getStatus(), locale))).add(node);
        }
        return publications;
    }

    private void processWorkflowComments(Workflow workflow, Bindings bindings) {
        List<WorkflowComment> workflowCommentsList = workflow.getComments();
        if (workflowCommentsList != null) {
            LinkedList comments = new LinkedList();
            for (WorkflowComment workflowComment : workflowCommentsList) {
                LinkedHashMap<String, Object> commentInfo = new LinkedHashMap<String, Object>();
                commentInfo.put("comment", workflowComment.getComment());
                commentInfo.put("time", workflowComment.getTime());
                JCRUserNode user = this.userManagerService.lookupUserByPath(workflowComment.getUser());
                if (user != null) {
                    commentInfo.put("userName", PrincipalViewHelper.getFullName(user));
                }
                comments.add(commentInfo);
            }
            bindings.put("comments", (Object)comments);
        }
    }

    private void initPublicationsMap(Map<String, List<Map<String, Object>>> publications, Locale locale) {
        publications.put(this.getPublicationLabelI18N(4, locale), new LinkedList());
        publications.put(this.getPublicationLabelI18N(3, locale), new LinkedList());
        publications.put(this.getPublicationLabelI18N(1, locale), new LinkedList());
        publications.put(this.getPublicationLabelI18N(12, locale), new LinkedList());
        publications.put(this.getPublicationLabelI18N(11, locale), new LinkedList());
        publications.put(this.getPublicationLabelI18N(5, locale), new LinkedList());
        publications.put(this.getPublicationLabelI18N(10, locale), new LinkedList());
        publications.put(this.getPublicationLabelI18N(6, locale), new LinkedList());
        publications.put(this.getPublicationLabelI18N(8, locale), new LinkedList());
        publications.put(this.getPublicationLabelI18N(7, locale), new LinkedList());
        publications.put(this.getPublicationLabelI18N(9, locale), new LinkedList());
    }

    private String getPublicationLabelI18N(int status, Locale locale) {
        String publicationResourceKey = String.format("label.publication.%s", PublicationInfo.getLabel(status));
        return Messages.getInternal(publicationResourceKey, locale);
    }

    protected void addAttachments(MailTemplate template, WorkItem workItem, Multipart multipart, JCRSessionWrapper session) throws Exception {
        for (AttachmentTemplate attachmentTemplate : template.getAttachmentTemplates()) {
            MimeBodyPart attachmentPart = new MimeBodyPart();
            String description = attachmentTemplate.getDescription();
            if (description != null) {
                attachmentPart.setDescription(this.evaluateExpression(workItem, description, session));
            }
            DataHandler dataHandler = this.createDataHandler(attachmentTemplate, workItem, session);
            attachmentPart.setDataHandler(dataHandler);
            String name = attachmentTemplate.getName();
            if (name != null) {
                attachmentPart.setFileName(this.evaluateExpression(workItem, name, session));
            } else {
                DataSource dataSource = dataHandler.getDataSource();
                name = dataSource instanceof URLDataSource ? JBPMMailProducer.extractResourceName(((URLDataSource)dataSource).getURL()) : dataSource.getName();
                if (name != null) {
                    attachmentPart.setFileName(name);
                }
            }
            multipart.addBodyPart((BodyPart)attachmentPart);
        }
    }

    protected DataHandler createDataHandler(AttachmentTemplate attachmentTemplate, WorkItem workItem, JCRSessionWrapper session) throws Exception {
        URL targetUrl;
        String expression = attachmentTemplate.getExpression();
        if (expression != null) {
            String object = this.evaluateExpression(workItem, expression, session);
            return new DataHandler((Object)object, attachmentTemplate.getMimeType());
        }
        String file = attachmentTemplate.getFile();
        if (file != null) {
            File targetFile = new File(this.evaluateExpression(workItem, file, session));
            if (!targetFile.isFile()) {
                throw new Exception("could not read attachment content, file not found: " + targetFile);
            }
            return new DataHandler((DataSource)new FileDataSource(targetFile));
        }
        String url = attachmentTemplate.getUrl();
        if (url != null) {
            url = this.evaluateExpression(workItem, url, session);
            targetUrl = new URL(url);
        } else {
            String resource = this.evaluateExpression(workItem, attachmentTemplate.getResource(), session);
            targetUrl = Thread.currentThread().getContextClassLoader().getResource(resource);
            if (targetUrl == null) {
                throw new Exception("could not read attachment content, resource not found: " + resource);
            }
        }
        return new DataHandler(targetUrl);
    }

    protected static String extractResourceName(URL url) {
        String path = url.getPath();
        if (path == null || path.length() == 0) {
            return null;
        }
        int sepIndex = path.lastIndexOf(47);
        return sepIndex != -1 ? path.substring(sepIndex + 1) : null;
    }

    public class MyBindings
    extends SimpleBindings {
        protected final WorkItem workItem;

        public MyBindings(WorkItem workItem) {
            this.workItem = workItem;
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(key) || this.workItem.getParameter((String)key) != null;
        }

        @Override
        public Object get(Object key) {
            return super.containsKey(key) ? super.get(key) : this.workItem.getParameter((String)key);
        }
    }
}

