/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.kie.api.runtime.process.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetActiveWorkflowsInformationsCommand
extends BaseCommand<List<Workflow>> {
    private static transient Logger logger = LoggerFactory.getLogger(GetActiveWorkflowsInformationsCommand.class);
    private final List<String> processIds;
    private final Locale uiLocale;

    public GetActiveWorkflowsInformationsCommand(List<String> processIds, Locale uiLocale) {
        this.processIds = processIds;
        this.uiLocale = uiLocale;
    }

    @Override
    public List<Workflow> execute() {
        ArrayList<Workflow> activeWorkflows = new ArrayList<Workflow>();
        for (String processId : this.processIds) {
            ProcessInstance processInstance = this.getKieSession().getProcessInstance(Long.parseLong(processId));
            if (processInstance != null) {
                activeWorkflows.add(this.convertToWorkflow(processInstance, this.uiLocale, this.getKieSession(), this.getTaskService(), this.getLogService()));
                continue;
            }
            logger.debug("Retrieving process instance with ID {} returned null while getting active workflows", (Object)processId);
        }
        return activeWorkflows;
    }

    @Override
    public String toString() {
        return super.toString() + String.format("%n processIds: %s", Joiner.on((String)",").join(this.processIds)) + String.format("%n uiLocale: %s", this.uiLocale);
    }
}

