/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import java.util.ArrayList;
import java.util.Date;
import org.jahia.services.workflow.WorkflowComment;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;

public class AddCommentCommand
extends BaseCommand<Object> {
    private final String processId;
    private final String comment;
    private final String user;

    public AddCommentCommand(String processId, String comment, String user) {
        this.processId = processId;
        this.comment = comment;
        this.user = user;
    }

    @Override
    public Object execute() {
        KieSession ksession = this.getKieSession();
        ProcessInstance processInstance = ksession.getProcessInstance(Long.parseLong(this.processId));
        WorkflowProcessInstance workflowProcessInstance = (WorkflowProcessInstance)processInstance;
        ArrayList<WorkflowComment> comments = (ArrayList<WorkflowComment>)workflowProcessInstance.getVariable("comments");
        if (comments == null) {
            comments = new ArrayList<WorkflowComment>();
        }
        WorkflowComment wfComment = new WorkflowComment();
        wfComment.setComment(this.comment);
        wfComment.setUser(this.user);
        wfComment.setTime(new Date());
        comments.add(wfComment);
        workflowProcessInstance.setVariable("comments", comments);
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + String.format("%n processId: %s", this.processId) + String.format("%n comment: %s", this.comment) + String.format("%n user: %s", this.user);
    }
}

