/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.bin.filters.jcr.JcrSessionFilter;
import org.jahia.osgi.FrameworkService;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.hazelcast.HazelcastTopic;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.workflow.HistoryWorkflow;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowListener;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowTask;
import org.jahia.settings.SettingsBean;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowObservationManager
implements HazelcastTopic.MessageListener<Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowObservationManager.class);
    public static final String WORKFLOW_TOPIC = "org.jahia.broadcaster.wf";
    private WorkflowService service;
    private HazelcastTopic hazelcastTopic;
    private String listenerId;
    private List<WorkflowListener> listeners = new ArrayList<WorkflowListener>();

    public WorkflowObservationManager(WorkflowService service) {
        this.service = service;
    }

    public void initAfterAllServicesAreStarted() {
        ServiceTracker st = new ServiceTracker(FrameworkService.getBundleContext(), HazelcastTopic.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<HazelcastTopic, HazelcastTopic>(){

            public HazelcastTopic addingService(ServiceReference<HazelcastTopic> serviceReference) {
                HazelcastTopic service = (HazelcastTopic)FrameworkService.getBundleContext().getService(serviceReference);
                WorkflowObservationManager.this.hazelcastTopic = service;
                WorkflowObservationManager.this.listenerId = service.addListener("workflowEvents", WorkflowObservationManager.this);
                return service;
            }

            public void modifiedService(ServiceReference<HazelcastTopic> serviceReference, HazelcastTopic hazelcastTopic) {
            }

            public void removedService(ServiceReference<HazelcastTopic> serviceReference, HazelcastTopic hazelcastTopic) {
                hazelcastTopic.removeListener("workflowEvents", WorkflowObservationManager.this.listenerId);
                WorkflowObservationManager.this.hazelcastTopic = null;
            }
        });
        st.open();
    }

    public void notifyWorkflowStarted(String provider, String workflowId) {
        Workflow wf = this.service.getWorkflow(provider, workflowId, null);
        this.notifyWorkflowStarted(wf);
        this.sendRemote("notifyWorkflowStarted", wf);
    }

    private void notifyWorkflowStarted(Workflow wf) {
        for (WorkflowListener listener : this.listeners) {
            try {
                listener.workflowStarted(wf);
            }
            catch (Exception e) {
                logger.debug("Message cannot be delivered", (Throwable)e);
            }
        }
    }

    public void notifyWorkflowEnded(String provider, String workflowId) {
        HistoryWorkflow wf = this.service.getHistoryWorkflow(workflowId, provider, null);
        this.notifyWorkflowEnded(wf);
        this.sendRemote("notifyWorkflowEnded", wf);
    }

    private void notifyWorkflowEnded(HistoryWorkflow wf) {
        for (WorkflowListener listener : this.listeners) {
            try {
                listener.workflowEnded(wf);
            }
            catch (Exception e) {
                logger.debug("Message cannot be delivered", (Throwable)e);
            }
        }
    }

    public void notifyNewTask(String provider, String taskId) {
        WorkflowTask task = this.service.getWorkflowTask(taskId, provider, null);
        this.notifyNewTask(task);
        this.sendRemote("notifyNewTask", task);
    }

    private void notifyNewTask(WorkflowTask task) {
        for (WorkflowListener listener : this.listeners) {
            try {
                listener.newTaskCreated(task);
            }
            catch (Exception e) {
                logger.debug("Message cannot be delivered", (Throwable)e);
            }
        }
    }

    public void notifyTaskEnded(String provider, String taskId) {
        WorkflowTask task = this.service.getWorkflowTask(taskId, provider, null);
        this.notifyTaskEnded(task);
        this.sendRemote("notifyTaskEnded", task);
    }

    private void notifyTaskEnded(WorkflowTask task) {
        for (WorkflowListener listener : this.listeners) {
            try {
                listener.taskEnded(task);
            }
            catch (Exception e) {
                logger.debug("Message cannot be delivered", (Throwable)e);
            }
        }
    }

    public void addWorkflowListener(WorkflowListener listener) {
        this.listeners.add(listener);
    }

    public void removeWorkflowListener(WorkflowListener listener) {
        this.listeners.remove(listener);
    }

    public void sendRemote(String type, Object obj) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.hazelcastTopic != null) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("type", type);
            m.put("user", JCRSessionFactory.getInstance().getCurrentUser());
            try (ObjectOutputStream oos = new ObjectOutputStream(out);){
                oos.writeObject(obj);
                m.put("data", out.toByteArray());
                m.put("source", SettingsBean.getInstance().getPropertyValue("cluster.node.serverId"));
                JobDetail messageJob = BackgroundJob.createJahiaJob("WorkflowMessageJob", MessageJob.class);
                messageJob.getJobDataMap().put((Object)"message", m);
                messageJob.getJobDataMap().put((Object)"hazelcastTopic", (Object)this.hazelcastTopic);
                ServicesRegistry.getInstance().getSchedulerService().getRAMScheduler().scheduleJob(messageJob, (Trigger)new SimpleTrigger(messageJob.getName() + "_Trigger", new Date(System.currentTimeMillis() + 2000L)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void onMessage(Map<String, Object> m) {
        if (!SettingsBean.getInstance().getPropertyValue("cluster.node.serverId").equals(m.get("source"))) {
            try (ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream((byte[])m.get("data")));){
                Object obj = is.readObject();
                JCRSessionFactory.getInstance().setCurrentUser((JahiaUser)m.get("user"));
                if (m.get("type").equals("notifyWorkflowStarted")) {
                    this.notifyWorkflowStarted((Workflow)obj);
                } else if (m.get("type").equals("notifyWorkflowEnded")) {
                    this.notifyWorkflowEnded((HistoryWorkflow)obj);
                } else if (m.get("type").equals("notifyNewTask")) {
                    this.notifyNewTask((WorkflowTask)obj);
                } else if (m.get("type").equals("notifyTaskEnded")) {
                    this.notifyTaskEnded((WorkflowTask)obj);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            finally {
                JcrSessionFilter.endRequest();
            }
        }
    }

    public static class MessageJob
    extends BackgroundJob {
        @Override
        public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
            JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
            Map m = (Map)jobDataMap.get((Object)"message");
            HazelcastTopic hazelcastTopic = (HazelcastTopic)jobDataMap.get((Object)"hazelcastTopic");
            hazelcastTopic.send("workflowEvents", m);
        }
    }
}

