/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.translation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.translation.TranslationException;
import org.jahia.services.translation.TranslationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class TranslationService {
    private static transient Logger logger = LoggerFactory.getLogger(TranslationService.class);
    private Map<String, TranslationProvider> providers = new HashMap<String, TranslationProvider>();

    public String translate(String text, String srcLanguage, String destLanguage, boolean isHtml, JCRSiteNode site, Locale uiLocale) throws TranslationException {
        if (StringUtils.isBlank((String)text)) {
            return text;
        }
        TranslationProvider provider = this.getFirstEnabledProvider(site);
        if (provider == null) {
            return text;
        }
        return provider.translate(text, srcLanguage, destLanguage, isHtml, site, uiLocale);
    }

    public List<String> translate(List<String> texts, String srcLanguage, String destLanguage, boolean isHtml, JCRSiteNode site, Locale uiLocale) throws TranslationException {
        List<String> translatedTexts;
        TranslationProvider provider = this.getFirstEnabledProvider(site);
        if (provider == null) {
            return texts;
        }
        ArrayList<StringWithIndex> blankTexts = new ArrayList<StringWithIndex>();
        for (int i = texts.size() - 1; i >= 0; --i) {
            String text = texts.get(i);
            if (!StringUtils.isBlank((String)text)) continue;
            blankTexts.add(0, new StringWithIndex(texts.remove(i), i));
        }
        if (!texts.isEmpty()) {
            if (texts.size() == 1) {
                translatedTexts = new ArrayList();
                translatedTexts.add(provider.translate(texts.get(0), srcLanguage, destLanguage, isHtml, site, uiLocale));
            } else {
                translatedTexts = provider.translate(texts, srcLanguage, destLanguage, isHtml, site, uiLocale);
            }
        } else {
            translatedTexts = new ArrayList<String>();
        }
        for (StringWithIndex blankText : blankTexts) {
            translatedTexts.add(blankText.index, blankText.text);
        }
        return translatedTexts;
    }

    private TranslationProvider getFirstEnabledProvider(JCRSiteNode site) {
        for (TranslationProvider p : this.providers.values()) {
            if (!p.isEnabled(site)) continue;
            return p;
        }
        return null;
    }

    public boolean isEnabled(JCRSiteNode site) {
        for (TranslationProvider p : this.providers.values()) {
            if (!p.isEnabled(site)) continue;
            return true;
        }
        return false;
    }

    public void addProvider(TranslationProvider provider) {
        this.providers.put(provider.getName(), provider);
    }

    private class StringWithIndex {
        String text;
        int index;

        StringWithIndex(String text, int index) {
            this.text = text;
            this.index = index;
        }
    }
}

