/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import org.apache.commons.lang.StringUtils;
import org.jahia.api.Constants;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class ModuleInstallationHelper
implements ApplicationEventPublisherAware {
    private static Logger logger = LoggerFactory.getLogger(ModuleInstallationHelper.class);
    private ApplicationEventPublisher applicationEventPublisher;
    private JahiaSitesService siteService;
    private TemplatePackageRegistry templatePackageRegistry;

    private boolean addDependencyValue(JCRNodeWrapper originalNode, JCRNodeWrapper destinationNode, String propertyName) throws RepositoryException {
        String valueToBeAdded;
        String newStringValue = valueToBeAdded = originalNode.getName();
        if (destinationNode.hasProperty(propertyName)) {
            JCRPropertyWrapper installedModules = destinationNode.getProperty(propertyName);
            JCRValueWrapper[] values = installedModules.getValues();
            LinkedList<String> stringValues = new LinkedList<String>();
            for (JCRValueWrapper value : values) {
                String strVal = value.getString();
                stringValues.add(strVal);
                if (!strVal.equals(valueToBeAdded)) continue;
                return true;
            }
            stringValues.add(valueToBeAdded);
            destinationNode.setProperty(propertyName, stringValues.toArray(new String[0]));
        } else {
            destinationNode.setProperty(propertyName, new String[]{newStringValue});
        }
        return false;
    }

    public void autoInstallModulesToSites(JahiaTemplatesPackage module, JCRSessionWrapper session) throws RepositoryException {
        HashSet<String> autoInstalled = new HashSet<String>();
        if (StringUtils.isNotBlank((String)module.getAutoDeployOnSite())) {
            if ("system".equals(module.getAutoDeployOnSite()) || "systemsite".equals(module.getAutoDeployOnSite())) {
                if (session.nodeExists("/sites/systemsite")) {
                    this.installModule(module, "/sites/systemsite", session);
                    autoInstalled.add("systemsite");
                }
            } else if ("all".equals(module.getAutoDeployOnSite()) && session.nodeExists("/sites/systemsite")) {
                this.installModuleOnAllSites(module, session, null);
                return;
            }
        }
        ArrayList<JCRNodeWrapper> sites = new ArrayList<JCRNodeWrapper>();
        JCRNodeIteratorWrapper ni = session.getNode("/sites").getNodes();
        while (ni.hasNext()) {
            JCRValueWrapper[] v;
            JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
            if (autoInstalled.contains(next.getName()) || !next.hasProperty("j:installedModules")) continue;
            for (JCRValueWrapper value : v = next.getProperty("j:installedModules").getValues()) {
                if (!value.getString().equals(module.getId())) continue;
                sites.add(next);
            }
        }
        if (!sites.isEmpty()) {
            this.installModuleOnAllSites(module, session, sites);
        }
    }

    public void installModule(JahiaTemplatesPackage module, String sitePath, JCRSessionWrapper session) throws RepositoryException {
        this.installModules(Collections.singletonList(module), sitePath, session);
    }

    public void installModule(final String moduleId, final String sitePath, String username) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(username, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                ModuleInstallationHelper.this.installModules(Collections.singletonList(ModuleInstallationHelper.this.templatePackageRegistry.lookupById(moduleId)), sitePath, session);
                session.save();
                return null;
            }
        });
    }

    public void installModule(final String moduleId, final String version, final String sitePath, String username) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(username, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                ModuleInstallationHelper.this.installModules(Collections.singletonList(ModuleInstallationHelper.this.templatePackageRegistry.lookupByIdAndVersion(moduleId, new ModuleVersion(version))), sitePath, session);
                session.save();
                return null;
            }
        });
    }

    public void installModuleOnAllSites(JahiaTemplatesPackage module, JCRSessionWrapper sessionWrapper, List<JCRNodeWrapper> sites) throws RepositoryException {
        if (sites == null) {
            sites = new ArrayList<JCRNodeWrapper>();
            JCRNodeIteratorWrapper ni = sessionWrapper.getNode("/sites").getNodes();
            while (ni.hasNext()) {
                JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
                if (!next.isNodeType("jnt:virtualsite")) continue;
                sites.add(next);
            }
        }
        JCRNodeWrapper tpl = sessionWrapper.getNode("/modules/" + module.getIdWithVersion());
        for (JCRNodeWrapper site : sites) {
            if (!site.isNodeType("jnt:virtualsite")) continue;
            if (tpl.hasProperty("j:moduleType") && "templatesSet".equals(tpl.getProperty("j:moduleType").getString())) {
                if (!tpl.getName().equals(site.getResolveSite().getTemplateFolder())) continue;
                this.installModule(module, site.getPath(), sessionWrapper);
                continue;
            }
            this.installModule(module, site.getPath(), sessionWrapper);
        }
    }

    public void installModules(List<JahiaTemplatesPackage> modules, String sitePath, JCRSessionWrapper session) throws RepositoryException {
        if (!sitePath.startsWith("/sites/")) {
            return;
        }
        JCRSiteNode siteNode = (JCRSiteNode)session.getNode(sitePath);
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        for (JahiaTemplatesPackage module : modules) {
            logger.info("Installing " + module.getName() + " on " + sitePath);
            JCRNodeWrapper moduleNode = null;
            try {
                moduleNode = session.getNode("/modules/" + module.getId());
                String moduleName = moduleNode.getName();
                if (moduleNode.isNodeType("jnt:module")) {
                    moduleNode = moduleNode.getNode(module.getVersion().toString());
                }
                this.synchro(moduleNode, siteNode, session, moduleName, references);
                ReferencesHelper.resolveCrossReferences(session, references);
                this.addDependencyValue(moduleNode.getParent(), siteNode, "j:installedModules");
                logger.info("Done installing " + module.getName() + " on " + sitePath);
            }
            catch (PathNotFoundException e) {
                logger.warn("Cannot find module for path {}. Skipping deployment to site {}.", (Object)module, (Object)sitePath);
                return;
            }
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new JahiaTemplateManagerService.ModuleDeployedOnSiteEvent(sitePath, ModuleInstallationHelper.class.getName()));
    }

    private void keepReference(JCRNodeWrapper destinationNode, Map<String, List<String>> references, Property property, String value) throws RepositoryException {
        if (!references.containsKey(value)) {
            references.put(value, new ArrayList());
        }
        references.get(value).add(destinationNode.getIdentifier() + "/" + property.getName());
    }

    public void purgeModuleContent(List<String> modules, String sitePath, JCRSessionWrapper session) throws RepositoryException {
        QueryManagerWrapper manager = session.getWorkspace().getQueryManager();
        for (String module : modules) {
            String workspaceName = session.getWorkspace().getName();
            logger.info("Purging content in workspace {} for node types, defined in module {}", (Object)workspaceName, (Object)module);
            NodeTypeRegistry.JahiaNodeTypeIterator nti = NodeTypeRegistry.getInstance().getNodeTypes(module);
            while (nti.hasNext()) {
                ExtendedNodeType nodeType = (ExtendedNodeType)nti.next();
                String nodeTypeName = nodeType.getName();
                Query q = manager.createQuery("select * from ['" + nodeTypeName + "'] as c where isdescendantnode(c,'" + JCRContentUtils.sqlEncode(sitePath) + "')", "JCR-SQL2");
                boolean isMixin = nodeType.isMixin();
                try {
                    NodeIterator ni = q.execute().getNodes();
                    int processedCount = 0;
                    while (ni.hasNext()) {
                        JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)ni.nextNode();
                        if (isMixin) {
                            nodeWrapper.removeMixin(nodeTypeName);
                        } else {
                            nodeWrapper.remove();
                        }
                        ++processedCount;
                    }
                    if (processedCount <= 0) continue;
                    if (isMixin) {
                        logger.info("Removed mixin {} from {} node(s) in workspace {}", new Object[]{nodeTypeName, processedCount, workspaceName});
                        continue;
                    }
                    logger.info("Removed {} node(s) of type {} in workspace {}", new Object[]{processedCount, nodeTypeName, workspaceName});
                }
                catch (RepositoryException e) {
                    logger.error("Cannot remove node", (Throwable)e);
                }
            }
            logger.info("... done purging content in workspace {} for node types, defined in module {}", (Object)workspaceName, (Object)module);
        }
    }

    public boolean checkExistingContent(final String module) throws RepositoryException {
        JCRCallback<Boolean> callback = new JCRCallback<Boolean>(){

            @Override
            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                QueryManagerWrapper manager = session.getWorkspace().getQueryManager();
                NodeTypeRegistry.JahiaNodeTypeIterator nti = NodeTypeRegistry.getInstance().getNodeTypes(module);
                while (nti.hasNext()) {
                    ExtendedNodeType next = (ExtendedNodeType)nti.next();
                    Query q = manager.createQuery("select * from ['" + next.getName() + "']", "JCR-SQL2");
                    if (!q.execute().getRows().hasNext()) continue;
                    return true;
                }
                return false;
            }
        };
        return JCRTemplate.getInstance().doExecuteWithSystemSession(callback) != false || JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, callback) != false;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setSiteService(JahiaSitesService siteService) {
        this.siteService = siteService;
    }

    public void setTemplatePackageRegistry(TemplatePackageRegistry registry) {
        this.templatePackageRegistry = registry;
    }

    public void synchro(JCRNodeWrapper source, JCRNodeWrapper destinationNode, JCRSessionWrapper session, String moduleName, Map<String, List<String>> references) throws RepositoryException {
        if (source.isNodeType("jnt:moduleVersion")) {
            session.getUuidMapping().put(source.getIdentifier(), destinationNode.getIdentifier());
            JCRNodeIteratorWrapper ni = source.getNodes();
            while (ni.hasNext()) {
                JCRNodeWrapper node;
                JCRNodeWrapper child = (JCRNodeWrapper)ni.next();
                if (child.isNodeType("jnt:versionInfo") || child.isNodeType("jnt:moduleVersionFolder") || child.isNodeType("jnt:externalProviderExtension") || child.isNodeType("jnt:templatesFolder") || child.isNodeType("jnt:componentFolder") || child.isNodeType("jnt:permission")) continue;
                boolean newNode = false;
                String childName = child.getName();
                if (destinationNode.hasNode(childName)) {
                    node = destinationNode.getNode(childName);
                } else {
                    session.checkout(destinationNode);
                    String primaryNodeTypeName = child.getPrimaryNodeTypeName();
                    node = destinationNode.addNode(childName, primaryNodeTypeName);
                    newNode = true;
                }
                this.templatesSynchro(child, node, session, references, newNode, true);
            }
        }
    }

    public void templatesSynchro(JCRNodeWrapper source, JCRNodeWrapper destinationNode, JCRSessionWrapper session, Map<String, List<String>> references, boolean doUpdate, boolean doChildren) throws RepositoryException {
        if ("j:acl".equals(destinationNode.getName())) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Synchronizing node : " + destinationNode.getPath() + ", update=" + doUpdate + "/children=" + doChildren);
        }
        session.checkout(destinationNode);
        Map<String, String> uuidMapping = session.getUuidMapping();
        ExtendedNodeType[] mixin = source.getMixinNodeTypes();
        List<ExtendedNodeType> destMixin = Arrays.asList(destinationNode.getMixinNodeTypes());
        for (ExtendedNodeType aMixin : mixin) {
            if (destMixin.contains(aMixin)) continue;
            destinationNode.addMixin(aMixin.getName());
        }
        uuidMapping.put(source.getIdentifier(), destinationNode.getIdentifier());
        ArrayList<String> names = new ArrayList<String>();
        if (doUpdate) {
            if (!(!source.hasProperty("jcr:language") || destinationNode.hasProperty("jcr:language") && destinationNode.getProperty("jcr:language").getString().equals(source.getProperty("jcr:language").getString()))) {
                destinationNode.setProperty("jcr:language", source.getProperty("jcr:language").getString());
            }
            PropertyIterator props = source.getProperties();
            while (props.hasNext()) {
                Property property = props.nextProperty();
                names.add(property.getName());
                try {
                    if (property.getDefinition().isProtected() || Constants.forbiddenPropertiesToCopy.contains(property.getName())) continue;
                    if (property.getType() == 9 || property.getType() == 10) {
                        if (property.getDefinition().isMultiple() && property.isMultiple()) {
                            Value[] values;
                            if (destinationNode.hasProperty(property.getName()) && Arrays.equals(destinationNode.getProperty(property.getName()).getValues(), property.getValues())) continue;
                            destinationNode.setProperty(property.getName(), new Value[0]);
                            Value[] valueArray = values = property.getValues();
                            int n = valueArray.length;
                            for (int i = 0; i < n; ++i) {
                                Value value = valueArray[i];
                                this.keepReference(destinationNode, references, property, value.getString());
                            }
                            continue;
                        }
                        if (destinationNode.hasProperty(property.getName()) && destinationNode.getProperty(property.getName()).getValue().equals(property.getValue())) continue;
                        this.keepReference(destinationNode, references, property, property.getValue().getString());
                        continue;
                    }
                    if (property.getDefinition().isMultiple() && property.isMultiple()) {
                        if (destinationNode.hasProperty(property.getName()) && Arrays.equals(destinationNode.getProperty(property.getName()).getValues(), property.getValues())) continue;
                        destinationNode.setProperty(property.getName(), property.getValues());
                        continue;
                    }
                    if (destinationNode.hasProperty(property.getName()) && destinationNode.getProperty(property.getName()).getValue().equals(property.getValue())) continue;
                    destinationNode.setProperty(property.getName(), property.getValue());
                }
                catch (Exception e) {
                    logger.warn("Unable to copy property '" + property.getName() + "'. Skipping.", (Throwable)e);
                }
            }
            PropertyIterator pi = destinationNode.getProperties();
            while (pi.hasNext()) {
                ExtendedNodeType[] oldChild = (ExtendedNodeType[])pi.next();
                if (oldChild.getDefinition().isProtected() || names.contains(oldChild.getName()) || oldChild.getName().equals("j:published") || oldChild.getName().equals("j:moduleTemplate") || oldChild.getName().equals("j:sourceTemplate")) continue;
                oldChild.remove();
            }
            for (ExtendedNodeType aMixin : mixin = destinationNode.getMixinNodeTypes()) {
                if (source.isNodeType(aMixin.getName())) continue;
                destinationNode.removeMixin(aMixin.getName());
            }
        }
        JCRNodeIteratorWrapper ni = source.getNodes();
        names.clear();
        while (ni.hasNext()) {
            JCRNodeWrapper node;
            JCRNodeWrapper child = (JCRNodeWrapper)ni.next();
            boolean isPageNode = child.isNodeType("jnt:page");
            if (!doChildren) continue;
            names.add(child.getName());
            boolean newNode = false;
            if (destinationNode.hasNode(child.getName())) {
                node = destinationNode.getNode(child.getName());
            } else {
                node = destinationNode.addNode(child.getName(), child.getPrimaryNodeTypeName());
                newNode = true;
            }
            this.templatesSynchro(child, node, session, references, newNode, doChildren && (!isPageNode || newNode));
        }
        if (doUpdate) {
            ArrayList<String> destNames = new ArrayList<String>();
            ni = destinationNode.getNodes();
            while (ni.hasNext()) {
                JCRNodeWrapper oldChild = (JCRNodeWrapper)ni.next();
                destNames.add(oldChild.getName());
            }
            if (destinationNode.getPrimaryNodeType().hasOrderableChildNodes() && !names.equals(destNames)) {
                Collections.reverse(names);
                String previous = null;
                for (String name : names) {
                    destinationNode.orderBefore(name, previous);
                    previous = name;
                }
            }
        }
    }

    public void uninstallModule(JahiaTemplatesPackage module, String sitePath, JCRSessionWrapper session) throws RepositoryException {
        this.uninstallModules(Collections.singletonList(module.getId()), sitePath, session);
    }

    private boolean uninstallModule(String sitePath, JCRSessionWrapper session, JCRSiteNode siteNode, String module) throws RepositoryException {
        logger.info("Uninstalling " + module + " on " + sitePath);
        try {
            JCRValueWrapper[] values;
            JCRPropertyWrapper installedModules = siteNode.getProperty("j:installedModules");
            LinkedList<String> stringValues = new LinkedList<String>();
            JCRValueWrapper toBeRemoved = null;
            for (JCRValueWrapper value : values = installedModules.getValues()) {
                String strValue = value.getString();
                if (strValue.equals(module)) {
                    toBeRemoved = value;
                    continue;
                }
                stringValues.add(strValue);
            }
            if (toBeRemoved != null) {
                siteNode.setProperty("j:installedModules", stringValues.toArray(new String[0]));
            }
            logger.info("Done uninstalling " + module + " on " + sitePath);
        }
        catch (PathNotFoundException e) {
            logger.warn("Cannot find module for path {}. Skipping deployment to site {}.", (Object)module, (Object)sitePath);
            return true;
        }
        return false;
    }

    public void uninstallModule(final String module, final String sitePath, String username, final boolean purgeAllContent) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(username, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                ModuleInstallationHelper.this.uninstallModules(Collections.singletonList(module), sitePath, session);
                if (purgeAllContent) {
                    ModuleInstallationHelper.this.purgeModuleContent(Collections.singletonList(module), sitePath, session);
                }
                session.save();
                return null;
            }
        });
        if (purgeAllContent) {
            JCRTemplate.getInstance().doExecuteWithSystemSession(username, "live", new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    ModuleInstallationHelper.this.purgeModuleContent(Collections.singletonList(module), sitePath, session);
                    session.save();
                    return null;
                }
            });
        }
    }

    public void uninstallModules(List<String> modules, String sitePath, JCRSessionWrapper session) throws RepositoryException {
        if (!sitePath.startsWith("/sites/")) {
            return;
        }
        JCRSiteNode siteNode = (JCRSiteNode)session.getNode(sitePath);
        for (String module : modules) {
            if (!this.uninstallModule(sitePath, session, siteNode, module)) continue;
            return;
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new JahiaTemplateManagerService.ModuleDeployedOnSiteEvent(sitePath, ModuleInstallationHelper.class.getName()));
    }

    public void uninstallModulesFromAllSites(String module, JCRSessionWrapper session) throws RepositoryException {
        this.uninstallModulesFromAllSites(Collections.singletonList(module), session);
    }

    public void uninstallModulesFromAllSites(List<String> modules, JCRSessionWrapper session) throws RepositoryException {
        List<JCRSiteNode> sitesList = this.siteService.getSitesNodeList(session);
        for (JCRSiteNode jahiaSite : sitesList) {
            for (String module : modules) {
                if (this.uninstallModule(jahiaSite.getName(), session, jahiaSite, module)) {
                    return;
                }
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new JahiaTemplateManagerService.ModuleDeployedOnSiteEvent(jahiaSite.getName(), ModuleInstallationHelper.class.getName()));
            }
        }
    }

    public void uninstallModulesFromAllSites(final String module, String username, final boolean purgeAllContent) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(username, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                ModuleInstallationHelper.this.uninstallModulesFromAllSites(module, session);
                if (purgeAllContent) {
                    ModuleInstallationHelper.this.purgeModuleContent(Collections.singletonList(module), "/sites", session);
                }
                session.save();
                return null;
            }
        });
        if (purgeAllContent) {
            JCRTemplate.getInstance().doExecuteWithSystemSession(username, "live", new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    ModuleInstallationHelper.this.purgeModuleContent(Collections.singletonList(module), "/sites", session);
                    session.save();
                    return null;
                }
            });
        }
    }
}

