/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.tika.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.tuckey.web.filters.urlrewrite.Conf;

public class Configuration
extends Conf {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);

    public Configuration() {
    }

    Configuration(InputStream is, String fileName) {
        super(is, fileName);
        super.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration(ServletContext context, InputStream is, Resource[] confLocations) {
        super(context, is, confLocations[0].getFilename(), confLocations[0].getDescription());
        IOUtils.closeQuietly((InputStream)is);
        for (int i = 1; i < confLocations.length; ++i) {
            Resource resource = confLocations[i];
            InputStream stream = null;
            try {
                stream = resource.getInputStream();
                this.loadDom(stream);
                continue;
            }
            catch (Exception e) {
                logger.error("Error loading URL rewrite rules from " + resource.getDescription(), (Throwable)e);
                continue;
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        super.initialise();
    }

    public Configuration(ServletContext context, Resource[] confLocations) throws IOException {
        this(context, confLocations[0].getInputStream(), confLocations);
    }

    public void initialise() {
    }
}

