/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public class VanityUrl
implements Serializable {
    private static final long serialVersionUID = 5736971828491108878L;
    private String url;
    private String language;
    private String identifier;
    private String path;
    private String site;
    private boolean defaultMapping;
    private boolean active;
    private boolean file;

    public VanityUrl() {
    }

    public VanityUrl(String url, String site, String language) {
        this.setUrl(url);
        this.site = site;
        this.language = language;
    }

    public VanityUrl(String url, String site, String language, boolean defaultMapping, boolean active) {
        this(url, site, language);
        this.defaultMapping = defaultMapping;
        this.active = active;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if ((url = StringUtils.stripEnd((String)url, (String)"/")) != null) {
            url = url.length() > 1 && url.charAt(0) == '/' && url.charAt(1) == '/' ? '/' + StringUtils.stripStart((String)url, (String)"/") : (url.length() > 0 && url.charAt(0) != '/' ? '/' + url : url);
        }
        this.url = url;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isDefaultMapping() {
        return this.defaultMapping;
    }

    public void setDefaultMapping(boolean defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public boolean isFile() {
        return this.file;
    }

    public void setFile(boolean file) {
        this.file = file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VanityUrl vanityUrl = (VanityUrl)o;
        if (this.defaultMapping != vanityUrl.defaultMapping) {
            return false;
        }
        if (this.active != vanityUrl.active) {
            return false;
        }
        if (this.url != null ? !this.url.equals(vanityUrl.url) : vanityUrl.url != null) {
            return false;
        }
        if (this.language != null ? !this.language.equals(vanityUrl.language) : vanityUrl.language != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(vanityUrl.identifier) : vanityUrl.identifier != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(vanityUrl.path) : vanityUrl.path != null) {
            return false;
        }
        return this.site != null ? this.site.equals(vanityUrl.site) : vanityUrl.site == null;
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.site != null ? this.site.hashCode() : 0);
        result = 31 * result + (this.defaultMapping ? 1 : 0);
        result = 31 * result + (this.active ? 1 : 0);
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

