/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search.analyzer;

import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.ASCIIFoldingFilter;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.FrenchStemmer;

public class FrenchSnowballAnalyzer
extends StopwordAnalyzerBase {
    private Set<?> excltable = CharArraySet.EMPTY_SET;

    public FrenchSnowballAnalyzer(Version matchVersion) {
        this(matchVersion, FrenchAnalyzer.getDefaultStopSet());
    }

    public FrenchSnowballAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, (Set<?>)CharArraySet.EMPTY_SET);
    }

    public FrenchSnowballAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclutionSet) {
        super(matchVersion, stopwords);
        this.excltable = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Version)matchVersion, stemExclutionSet));
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, reader);
        StandardFilter result = new StandardFilter(this.matchVersion, (TokenStream)source);
        result = new ElisionFilter(this.matchVersion, (TokenStream)result);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords);
        if (!this.excltable.isEmpty()) {
            result = new KeywordMarkerFilter((TokenStream)result, this.excltable);
        }
        result = new SnowballFilter((TokenStream)result, (SnowballProgram)new FrenchStemmer());
        result = new ASCIIFoldingFilter((TokenStream)result);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }
}

