/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.search.Hit;

public class SearchResponse {
    private List<Hit<?>> results = Collections.emptyList();
    private Collection<FacetedResult> facetedResults;
    private long offset = 0L;
    private long limit = -1L;
    private boolean hasMore = false;
    private long approxCount = 0L;

    public SearchResponse() {
    }

    public SearchResponse(List<Hit<?>> results) {
        this();
        this.setResults(results);
    }

    public List<Hit<?>> getResults() {
        return this.results;
    }

    public void setResults(List<Hit<?>> results) {
        this.results = results;
    }

    public Collection<FacetedResult> getFacetedResults() {
        return this.facetedResults;
    }

    public FacetedResult getFacetedResult(String facetDefinitionId) {
        if (this.facetedResults != null) {
            for (FacetedResult result : this.facetedResults) {
                if (!result.getId().equals(facetDefinitionId)) continue;
                return result;
            }
        }
        return null;
    }

    public void setFacetedResults(Collection<FacetedResult> facetedResults) {
        this.facetedResults = facetedResults != null ? Collections.unmodifiableCollection(facetedResults) : null;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }

    public long getApproxCount() {
        return this.approxCount;
    }

    public void setApproxCount(long approxCount) {
        this.approxCount = approxCount;
    }

    public static class FacetedResult {
        private String id;
        private List<Facet> facets;

        public FacetedResult(String id, List<Facet> facets) {
            if (id == null || id.length() == 0) {
                throw new IllegalArgumentException("Facet definition ID should not be null or empty");
            }
            this.id = id;
            this.facets = facets != null ? Collections.unmodifiableList(facets) : null;
        }

        public String getId() {
            return this.id;
        }

        public Facet getFacet(String valueAsString) {
            if (this.facets != null) {
                for (Facet f : this.facets) {
                    if (!StringUtils.equals((String)valueAsString, (String)f.getValueAsString())) continue;
                    return f;
                }
            }
            return null;
        }

        public List<Facet> getFacets() {
            return this.facets;
        }

        public boolean isResultEmpty() {
            if (this.facets != null) {
                for (Facet f : this.facets) {
                    if (f.isValueEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class Facet {
        private long count;
        private Object value;
        private String valueAsString;

        public Facet(Object value, String valueAsString, long count) {
            this.value = value;
            this.valueAsString = valueAsString;
            this.count = count;
        }

        public long getCount() {
            return this.count;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueAsString() {
            return this.valueAsString;
        }

        public boolean isValueEmpty() {
            return StringUtils.isEmpty((String)this.valueAsString);
        }
    }
}

