/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jahia.settings.readonlymode.ReadOnlyModeController;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;
import org.quartz.spi.JobFactory;

class ReadOnlyModeAwareScheduler
implements Scheduler {
    private Scheduler scheduler;
    private volatile boolean readOnlyMode = false;

    ReadOnlyModeAwareScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setReadOnly(boolean readOnlyMode) {
        this.readOnlyMode = readOnlyMode;
    }

    private void checkReadOnlyMode() {
        if (this.readOnlyMode) {
            ReadOnlyModeController.readOnlyModeViolated("The scheduler is currently in read-only mode and cannot perform any data or state modifications");
        }
    }

    public String getSchedulerName() throws SchedulerException {
        return this.scheduler.getSchedulerName();
    }

    public String getSchedulerInstanceId() throws SchedulerException {
        return this.scheduler.getSchedulerInstanceId();
    }

    public SchedulerContext getContext() throws SchedulerException {
        return this.scheduler.getContext();
    }

    public void start() throws SchedulerException {
        this.scheduler.start();
    }

    public void startDelayed(int seconds) throws SchedulerException {
        this.scheduler.startDelayed(seconds);
    }

    public boolean isStarted() throws SchedulerException {
        return this.scheduler.isStarted();
    }

    public void standby() throws SchedulerException {
        this.scheduler.standby();
    }

    public boolean isInStandbyMode() throws SchedulerException {
        return this.scheduler.isInStandbyMode();
    }

    public void shutdown() throws SchedulerException {
        this.scheduler.shutdown();
    }

    public void shutdown(boolean waitForJobsToComplete) throws SchedulerException {
        this.scheduler.shutdown();
    }

    public boolean isShutdown() throws SchedulerException {
        return this.scheduler.isShutdown();
    }

    public SchedulerMetaData getMetaData() throws SchedulerException {
        return this.scheduler.getMetaData();
    }

    public List<?> getCurrentlyExecutingJobs() throws SchedulerException {
        return this.scheduler.getCurrentlyExecutingJobs();
    }

    public void setJobFactory(JobFactory factory) throws SchedulerException {
        this.scheduler.setJobFactory(factory);
    }

    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        this.checkReadOnlyMode();
        return this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public Date scheduleJob(Trigger trigger) throws SchedulerException {
        this.checkReadOnlyMode();
        return this.scheduler.scheduleJob(trigger);
    }

    public boolean unscheduleJob(String triggerName, String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        return this.scheduler.unscheduleJob(triggerName, groupName);
    }

    public Date rescheduleJob(String triggerName, String groupName, Trigger newTrigger) throws SchedulerException {
        this.checkReadOnlyMode();
        return this.scheduler.rescheduleJob(triggerName, groupName, newTrigger);
    }

    public void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.addJob(jobDetail, replace);
    }

    public boolean deleteJob(String jobName, String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        return this.scheduler.deleteJob(jobName, groupName);
    }

    public void triggerJob(String jobName, String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.triggerJob(jobName, groupName);
    }

    public void triggerJobWithVolatileTrigger(String jobName, String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.triggerJobWithVolatileTrigger(jobName, groupName);
    }

    public void triggerJob(String jobName, String groupName, JobDataMap data) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.triggerJob(jobName, groupName, data);
    }

    public void triggerJobWithVolatileTrigger(String jobName, String groupName, JobDataMap data) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.triggerJobWithVolatileTrigger(jobName, groupName, data);
    }

    public void pauseJob(String jobName, String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.pauseJob(jobName, groupName);
    }

    public void pauseJobGroup(String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.pauseJobGroup(groupName);
    }

    public void pauseTrigger(String triggerName, String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.pauseTrigger(triggerName, groupName);
    }

    public void pauseTriggerGroup(String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.pauseTriggerGroup(groupName);
    }

    public void resumeJob(String jobName, String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.resumeJob(jobName, groupName);
    }

    public void resumeJobGroup(String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.resumeJobGroup(groupName);
    }

    public void resumeTrigger(String triggerName, String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.resumeTrigger(triggerName, groupName);
    }

    public void resumeTriggerGroup(String groupName) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.resumeTriggerGroup(groupName);
    }

    public void pauseAll() throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.pauseAll();
    }

    public void resumeAll() throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.resumeAll();
    }

    public String[] getJobGroupNames() throws SchedulerException {
        return this.scheduler.getJobGroupNames();
    }

    public String[] getJobNames(String groupName) throws SchedulerException {
        return this.scheduler.getJobNames(groupName);
    }

    public Trigger[] getTriggersOfJob(String jobName, String groupName) throws SchedulerException {
        return this.scheduler.getTriggersOfJob(jobName, groupName);
    }

    public String[] getTriggerGroupNames() throws SchedulerException {
        return this.scheduler.getTriggerGroupNames();
    }

    public String[] getTriggerNames(String groupName) throws SchedulerException {
        return this.scheduler.getTriggerNames(groupName);
    }

    public Set<?> getPausedTriggerGroups() throws SchedulerException {
        return this.scheduler.getPausedTriggerGroups();
    }

    public JobDetail getJobDetail(String jobName, String jobGroup) throws SchedulerException {
        return this.scheduler.getJobDetail(jobName, jobGroup);
    }

    public Trigger getTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        return this.scheduler.getTrigger(triggerName, triggerGroup);
    }

    public int getTriggerState(String triggerName, String triggerGroup) throws SchedulerException {
        return this.scheduler.getTriggerState(triggerName, triggerGroup);
    }

    public void addCalendar(String calName, Calendar calendar, boolean replace, boolean updateTriggers) throws SchedulerException {
        this.checkReadOnlyMode();
        this.scheduler.addCalendar(calName, calendar, replace, updateTriggers);
    }

    public boolean deleteCalendar(String calName) throws SchedulerException {
        this.checkReadOnlyMode();
        return this.scheduler.deleteCalendar(calName);
    }

    public Calendar getCalendar(String calName) throws SchedulerException {
        return this.scheduler.getCalendar(calName);
    }

    public String[] getCalendarNames() throws SchedulerException {
        return this.scheduler.getCalendarNames();
    }

    public boolean interrupt(String jobName, String groupName) throws UnableToInterruptJobException {
        this.checkReadOnlyMode();
        return this.scheduler.interrupt(jobName, groupName);
    }

    public void addGlobalJobListener(JobListener jobListener) throws SchedulerException {
        this.scheduler.addGlobalJobListener(jobListener);
    }

    public void addJobListener(JobListener jobListener) throws SchedulerException {
        this.scheduler.addJobListener(jobListener);
    }

    public boolean removeGlobalJobListener(String name) throws SchedulerException {
        return this.scheduler.removeGlobalJobListener(name);
    }

    public boolean removeJobListener(String name) throws SchedulerException {
        return this.scheduler.removeJobListener(name);
    }

    public List<?> getGlobalJobListeners() throws SchedulerException {
        return this.scheduler.getGlobalJobListeners();
    }

    public Set<?> getJobListenerNames() throws SchedulerException {
        return this.scheduler.getJobListenerNames();
    }

    public JobListener getGlobalJobListener(String name) throws SchedulerException {
        return this.scheduler.getGlobalJobListener(name);
    }

    public JobListener getJobListener(String name) throws SchedulerException {
        return this.scheduler.getJobListener(name);
    }

    public void addGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        this.scheduler.addGlobalTriggerListener(triggerListener);
    }

    public void addTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        this.scheduler.addTriggerListener(triggerListener);
    }

    public boolean removeGlobalTriggerListener(String name) throws SchedulerException {
        return this.scheduler.removeGlobalTriggerListener(name);
    }

    public boolean removeTriggerListener(String name) throws SchedulerException {
        return this.scheduler.removeTriggerListener(name);
    }

    public List<?> getGlobalTriggerListeners() throws SchedulerException {
        return this.scheduler.getGlobalTriggerListeners();
    }

    public Set<?> getTriggerListenerNames() throws SchedulerException {
        return this.scheduler.getTriggerListenerNames();
    }

    public TriggerListener getGlobalTriggerListener(String name) throws SchedulerException {
        return this.scheduler.getGlobalTriggerListener(name);
    }

    public TriggerListener getTriggerListener(String name) throws SchedulerException {
        return this.scheduler.getTriggerListener(name);
    }

    public void addSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        this.scheduler.addSchedulerListener(schedulerListener);
    }

    public boolean removeSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        return this.scheduler.removeSchedulerListener(schedulerListener);
    }

    public List<?> getSchedulerListeners() throws SchedulerException {
        return this.scheduler.getSchedulerListeners();
    }
}

