/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ComparatorUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.settings.SettingsBean;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JobSchedulingBean
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(JobSchedulingBean.class);
    private boolean disabled;
    private boolean isRamJob;
    private JobDetail jobDetail;
    private Boolean overwriteExisting;
    private SchedulerService schedulerService;
    private SettingsBean settingsBean;
    private List<Trigger> triggers = new LinkedList<Trigger>();

    public void afterPropertiesSet() throws Exception {
        if (this.disabled || !this.isEligibleToManageJob()) {
            return;
        }
        if (this.overwriteExisting == null) {
            this.overwriteExisting = this.settingsBean.isDevelopmentMode();
        }
        if (this.jobDetail == null) {
            logger.info("No JobDetail data was specified. Skip scheduling job.");
            return;
        }
        JobDetail existingJobDetail = this.getScheduler().getJobDetail(this.jobDetail.getName(), this.jobDetail.getGroup());
        if (this.overwriteExisting.booleanValue() || existingJobDetail == null) {
            this.deleteJob();
            this.createJob(true);
            this.scheduleJob(true);
        } else if (this.needToRescheduleTheJob()) {
            this.scheduleJob(true);
        }
    }

    public void destroy() throws Exception {
        if (!this.isEligibleToManageJob()) {
            return;
        }
        if (JahiaContextLoaderListener.isRunning()) {
            if (this.isRamJob) {
                this.deleteJob();
            } else {
                this.unscheduleJob();
            }
        }
    }

    protected Scheduler getScheduler() {
        return this.isRamJob ? this.schedulerService.getRAMScheduler() : this.schedulerService.getScheduler();
    }

    protected String getTriggerInfo(Trigger trigger) {
        return trigger instanceof CronTrigger && ((CronTrigger)trigger).getCronExpression() != null ? "CronTrigger [" + ((CronTrigger)trigger).getCronExpression() + "]" : trigger.toString();
    }

    protected boolean needToRescheduleTheJob() throws SchedulerException {
        Map<String, Trigger> existingTriggers = this.mapByName(this.getScheduler().getTriggersOfJob(this.jobDetail.getName(), this.jobDetail.getGroup()));
        if (existingTriggers.size() != this.triggers.size()) {
            return true;
        }
        Map<String, Trigger> newTriggers = this.mapByName(this.triggers.toArray(new Trigger[0]));
        if (!CollectionUtils.disjunction(existingTriggers.keySet(), newTriggers.keySet()).isEmpty()) {
            return true;
        }
        for (Map.Entry<String, Trigger> existing : existingTriggers.entrySet()) {
            Trigger newTrigger = newTriggers.get(existing.getKey());
            Trigger existingTrigger = existing.getValue();
            if (!existingTrigger.getClass().getName().equals(newTrigger.getClass().getName())) {
                return true;
            }
            if (!(existingTrigger instanceof CronTrigger) || ComparatorUtils.naturalComparator().compare(((CronTrigger)existingTrigger).getCronExpression(), ((CronTrigger)newTrigger).getCronExpression()) == 0) continue;
            return true;
        }
        return false;
    }

    protected void createJob(boolean deleteFirst) throws SchedulerException {
        this.getScheduler().addJob(this.jobDetail, deleteFirst);
    }

    protected void scheduleJob(boolean deleteFirst) throws SchedulerException {
        if (deleteFirst) {
            this.unscheduleJob();
        }
        if (this.triggers.size() == 0) {
            logger.info("Job has no triggers configured. Only the JobDetail data will be stored.");
        }
        for (Trigger trigger : this.triggers) {
            trigger.setJobName(this.jobDetail.getName());
            trigger.setJobGroup(this.jobDetail.getGroup());
            logger.info("Scheduling {} job {} using {}", (Object[])new String[]{this.isRamJob ? "RAM" : "persistent", this.jobDetail.getFullName(), this.getTriggerInfo(trigger)});
            this.getScheduler().scheduleJob(trigger);
        }
    }

    protected void deleteJob() throws SchedulerException {
        logger.info("Deleting job {}", (Object)this.jobDetail.getFullName());
        this.getScheduler().deleteJob(this.jobDetail.getName(), this.jobDetail.getGroup());
    }

    protected void unscheduleJob() throws SchedulerException {
        Trigger[] triggers;
        logger.info("Unscheduling job {}", (Object)this.jobDetail.getFullName());
        for (Trigger trigger : triggers = this.getScheduler().getTriggersOfJob(this.jobDetail.getName(), this.jobDetail.getGroup())) {
            this.getScheduler().unscheduleJob(trigger.getName(), trigger.getGroup());
        }
    }

    private boolean isEligibleToManageJob() {
        return this.isRamJob || this.settingsBean.isProcessingServer();
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public void setOverwriteExisting(boolean overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
    }

    public void setRamJob(boolean ramJob) {
        this.isRamJob = ramJob;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }

    public void setTrigger(Trigger trigger) {
        if (trigger != null) {
            this.triggers.add(trigger);
        }
    }

    public void setTriggers(List<Trigger> triggers) {
        if (triggers != null) {
            this.triggers.addAll(triggers);
        }
    }

    protected Map<String, Trigger> mapByName(Trigger[] triggers) {
        if (triggers == null || triggers.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Trigger> map = new HashMap<String, Trigger>(triggers.length);
        for (Trigger trg : triggers) {
            map.put(trg.getFullName(), trg);
        }
        return map;
    }
}

