/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;
import org.jahia.services.scheduler.SchedulerService;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.listeners.JobListenerSupport;

class JahiaJobListener
extends JobListenerSupport {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private static final String MSG_FINISHED = "Background job {} (of type {}) finished with status '{}' in {} {}";
    private static final String MSG_STARTED = "Background job {} (of type {}) started @ {}";
    private final Map<String, JobListener> jobListeners = new HashMap<String, JobListener>();
    private boolean isRamScheduler;

    public JahiaJobListener(boolean isRamScheduler) {
        this.isRamScheduler = isRamScheduler;
    }

    public String getName() {
        return this.isRamScheduler ? "JahiaRAMJobListener" : "JahiaJobListener";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobToBeExecuted(JobExecutionContext ctx) {
        try {
            long now = System.currentTimeMillis();
            JobDetail jobDetail = ctx.getJobDetail();
            if (SchedulerService.logger.isInfoEnabled()) {
                Object[] params = new String[]{jobDetail.getName(), jobDetail.getGroup(), DF.format(now)};
                if (this.isRamScheduler) {
                    SchedulerService.logger.debug(MSG_STARTED, params);
                } else {
                    SchedulerService.logger.info(MSG_STARTED, params);
                }
            }
            jobDetail.getJobDataMap().putAsString("begin", ctx.getFireTime() != null ? ctx.getFireTime().getTime() : now);
            jobDetail.getJobDataMap().put("status", "executing");
            ctx.getScheduler().addJob(jobDetail, true);
        }
        catch (SchedulerException e) {
            SchedulerService.logger.warn("Cannot update job", (Throwable)e);
        }
        Map<String, JobListener> map = this.jobListeners;
        synchronized (map) {
            for (JobListener jobListener : this.jobListeners.values()) {
                jobListener.jobToBeExecuted(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobExecutionVetoed(JobExecutionContext ctx) {
        Map<String, JobListener> map = this.jobListeners;
        synchronized (map) {
            for (JobListener jobListener : this.jobListeners.values()) {
                jobListener.jobExecutionVetoed(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext ctx, JobExecutionException jobException) {
        JobDataMap jobData = ctx.getJobDetail().getJobDataMap();
        String status = "successful";
        if (jobException != null) {
            status = "failed";
            jobData.put("message", jobException.getMessage());
        }
        long duration = ctx.getJobRunTime();
        jobData.putAsString("end", ctx.getFireTime().getTime() + ctx.getJobRunTime());
        jobData.putAsString("duration", duration);
        jobData.put("status", ctx.getTrigger().getNextFireTime() != null ? "scheduled" : status);
        if (SchedulerService.logger.isInfoEnabled()) {
            Object[] params = new String[]{ctx.getJobDetail().getName(), ctx.getJobDetail().getGroup(), status, String.valueOf(duration < 1000L ? duration : duration / 1000L), duration < 1000L ? "ms" : "sec"};
            if (this.isRamScheduler) {
                SchedulerService.logger.debug(MSG_FINISHED, params);
            } else {
                SchedulerService.logger.info(MSG_FINISHED, params);
            }
        }
        Map<String, JobListener> map = this.jobListeners;
        synchronized (map) {
            for (JobListener jobListener : this.jobListeners.values()) {
                jobListener.jobWasExecuted(ctx, jobException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addJobListener(JobListener jobListener) {
        Map<String, JobListener> map = this.jobListeners;
        synchronized (map) {
            this.jobListeners.put(jobListener.getName(), jobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeJobListener(String name) {
        Map<String, JobListener> map = this.jobListeners;
        synchronized (map) {
            this.jobListeners.remove(name);
        }
    }
}

