/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.webflow;

import java.util.ArrayList;
import org.jahia.osgi.BundleUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.validation.BeanValidationHintResolver;

public class JahiaBeanValidationHintResolver
extends BeanValidationHintResolver {
    public Class<?>[] resolveValidationHints(Object model, String flowId, String stateId, String[] hints) throws FlowExecutionException {
        if (ObjectUtils.isEmpty((Object[])hints)) {
            return null;
        }
        ArrayList<Class> result = new ArrayList<Class>();
        for (String hint : hints) {
            Class resolvedHint;
            if (hint.equalsIgnoreCase("Default")) {
                hint = "javax.validation.groups.Default";
            }
            if ((resolvedHint = this.toClass(hint)) == null && model != null) {
                resolvedHint = this.findInnerClass(model.getClass(), StringUtils.capitalize((String)hint));
            }
            if (resolvedHint == null) {
                resolvedHint = this.handleUnresolvedHint(model, flowId, stateId, hint);
            }
            if (resolvedHint == null) continue;
            result.add(resolvedHint);
        }
        return result.toArray(new Class[result.size()]);
    }

    private Class<?> toClass(String hint) {
        try {
            return BundleUtils.loadModuleClass(hint);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Class<?> findInnerClass(Class<?> targetClass, String hint) {
        try {
            return BundleUtils.loadModuleClass(targetClass.getName() + "$" + hint);
        }
        catch (ClassNotFoundException e) {
            Class<?> superClass = targetClass.getSuperclass();
            if (superClass != null) {
                return this.findInnerClass(superClass, hint);
            }
            return null;
        }
    }
}

