/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.monitoring;

import javax.servlet.http.HttpServletRequest;
import org.jahia.exceptions.RenderTimeLimitExceededException;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderTimeMonitor;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.ConditionalExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRenderTimeMonitor
extends ConditionalExecution
implements RenderTimeMonitor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRenderTimeMonitor.class);
    private static final String REQUEST_ATTR_NAME = RenderTimeMonitor.class.getName() + ".start";
    private long maxRequestRenderTime;

    private long getExecutionTime(HttpServletRequest request) {
        Long startTime = (Long)request.getAttribute(REQUEST_ATTR_NAME);
        if (startTime == null) {
            throw new IllegalStateException("Render chain monitoring has not been started for current HTTP request");
        }
        return System.currentTimeMillis() - startTime;
    }

    public long getMaxRequestRenderTime() {
        return this.maxRequestRenderTime;
    }

    @Override
    public void monitor(Resource resource, RenderContext renderContext) throws RenderTimeLimitExceededException {
        if (this.maxRequestRenderTime <= 0L || !this.areConditionsMatched(renderContext, resource)) {
            return;
        }
        long time = this.getExecutionTime(renderContext.getRequest());
        if (time > this.maxRequestRenderTime) {
            String msg = new StringBuffer(512).append("Request rendering time (").append(time).append(" ms) exceeded the maximum configured one (").append(this.maxRequestRenderTime).append(" ms). The request processing will be stopped. Last rendered resource: ").append(resource).append(". Main resource: ").append(renderContext.getMainResource()).append(". Request URL: ").append(renderContext.getRequest().getRequestURL()).toString();
            logger.warn(msg);
            throw new RenderTimeLimitExceededException(msg, time, this.maxRequestRenderTime);
        }
    }

    public void setMaxRequestRenderTime(long maxRequestRenderTime) {
        this.maxRequestRenderTime = maxRequestRenderTime;
    }

    @Override
    public void track(HttpServletRequest request) {
        if (this.maxRequestRenderTime > 0L && request.getAttribute(REQUEST_ATTR_NAME) == null) {
            request.setAttribute(REQUEST_ATTR_NAME, (Object)System.currentTimeMillis());
        }
    }
}

