/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.settings.readonlymode.ReadOnlyModeController;

public class ReadOnlyCacheKeyPartGenerator
implements CacheKeyPartGenerator {
    public static final String CACHE_READ_ONLY = "cache.readOnly";
    public static final String READ_ONLY = "read_only";
    public static final String READ_ONLY_KEY = "_ro_";

    @Override
    public String getKey() {
        return READ_ONLY;
    }

    @Override
    public String getValue(Resource resource, RenderContext renderContext, Properties properties) {
        if (Boolean.TRUE.toString().equals(properties.getProperty(CACHE_READ_ONLY))) {
            return READ_ONLY_KEY;
        }
        return "";
    }

    @Override
    public String replacePlaceholders(RenderContext renderContext, String keyPart) {
        String readOnlyStatus = ReadOnlyModeController.getInstance().getReadOnlyStatus().name();
        return StringUtils.replace((String)keyPart, (String)READ_ONLY_KEY, (String)readOnlyStatus);
    }
}

