/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.exceptions.JahiaServiceUnavailableException;
import org.jahia.services.cache.CacheEntry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.services.render.filter.cache.DefaultCacheKeyGenerator;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.render.filter.cache.ModuleGeneratorQueue;
import org.jahia.services.render.filter.cache.ModuleParamsCacheKeyPartGenerator;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.jvm.ThreadMonitor;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.web.util.HtmlUtils;

@Deprecated
public class AggregateCacheFilter
extends AbstractFilter
implements ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent> {
    protected static final transient Logger logger = LoggerFactory.getLogger(AggregateCacheFilter.class);
    public static final String CACHE_PER_USER = "cache.perUser";
    public static final String PER_USER = "j:perUser";
    public static final String CACHE_EXPIRATION = "cache.expiration";
    public static final String HAS_PROCESSING_SEMAPHORE_PARAM = "aggregateCacheFilter.hasProcessingSemaphore";
    public static final String EMPTY_USERKEY = "";
    public static final String ALL = "ALL";
    public static final Set<String> ALL_SET = Collections.singleton("ALL");
    private static final String CACHE_TAG_START_1_NOSRC = "<!-- cache:include";
    private static final String CACHE_TAG_START_1 = "<!-- cache:include src=\"";
    private static final String CACHE_TAG_START_2 = "\" -->";
    private static final String CACHE_TAG_END = "<!-- /cache:include -->";
    private static final String CACHE_ESI_TAG_START = "<jahia_esi:include src=\"";
    private static final String CACHE_ESI_TAG_END = "\"></jahia_esi:include>";
    private static final int CACHE_ESI_TAG_END_LENGTH = "\"></jahia_esi:include>".length();
    private static final int CACHE_TAG_LENGTH = "<!-- cache:include src=\"".length() + "\" -->".length() + "<!-- /cache:include -->".length();
    private static final String V = "v";
    private static final String EC = "ec";
    public static final TextUtils.ReplacementGenerator GENERATOR = new TextUtils.ReplacementGenerator(){

        @Override
        public void appendReplacementForMatch(int matchStart, int matchEnd, char[] initialStringAsCharArray, StringBuilder builder, String prefix, String suffix) {
            int firstQuoteIndex = matchStart;
            while (initialStringAsCharArray[firstQuoteIndex++] != '\"') {
            }
            int secondQuoteIndex = firstQuoteIndex + 1;
            while (initialStringAsCharArray[secondQuoteIndex++] != '\"') {
            }
            builder.append(AggregateCacheFilter.CACHE_ESI_TAG_START).append(initialStringAsCharArray, firstQuoteIndex, secondQuoteIndex - firstQuoteIndex - 1).append(AggregateCacheFilter.CACHE_ESI_TAG_END);
        }
    };
    protected ModuleCacheProvider cacheProvider;
    protected ModuleGeneratorQueue generatorQueue;
    protected static final Pattern CLEANUP_REGEXP = Pattern.compile("<!-- [/]?cache:include [^>]*-->");
    protected static final Map<String, Boolean> notCacheableFragment = new ConcurrentHashMap<String, Boolean>(512);
    protected static ThreadLocal<Set<CountDownLatch>> processingLatches = new ThreadLocal();
    protected static ThreadLocal<LinkedList<String>> userKeys = new ThreadLocal();
    protected static long lastThreadDumpTime = 0L;
    protected Byte[] threadDumpCheckLock = new Byte[0];
    protected int dependenciesLimit = 1000;
    protected boolean cascadeFragmentErrors = false;
    protected int errorCacheExpiration = 5;
    private Set<String> skipLatchForConfigurations;
    private Set<String> skipLatchForPaths;
    private Set<String> skipLatchForNodeTypes;

    public void setDependenciesLimit(int dependenciesLimit) {
        this.dependenciesLimit = dependenciesLimit;
    }

    public void setCacheProvider(ModuleCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setGeneratorQueue(ModuleGeneratorQueue generatorQueue) {
        this.generatorQueue = generatorQueue;
    }

    public void setCascadeFragmentErrors(boolean cascadeFragmentErrors) {
        this.cascadeFragmentErrors = cascadeFragmentErrors;
    }

    public void setErrorCacheExpiration(int errorCacheExpiration) {
        this.errorCacheExpiration = errorCacheExpiration;
    }

    public void setSkipLatchForConfigurations(Set<String> skipLatchForConfigurations) {
        this.skipLatchForConfigurations = skipLatchForConfigurations;
    }

    public void setSkipLatchForPaths(Set<String> skipLatchForPaths) {
        this.skipLatchForPaths = skipLatchForPaths;
    }

    public void setSkipLatchForNodeTypes(Set<String> skipLatchForNodeTypes) {
        this.skipLatchForNodeTypes = skipLatchForNodeTypes;
    }

    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        boolean debugEnabled = logger.isDebugEnabled();
        Properties properties = this.getAttributesForKey(renderContext, resource);
        Map<String, Serializable> moduleParams = resource.getModuleParams();
        Boolean forceGeneration = (Boolean)moduleParams.remove("cache.forceGeneration");
        String key = this.cacheProvider.getKeyGenerator().generate(resource, renderContext, properties);
        moduleParams.put("cacheKey", (Serializable)((Object)key));
        if (debugEnabled) {
            logger.debug("Cache filter for key with placeholders : {}", (Object)key);
        }
        String finalKey = this.replacePlaceholdersInCacheKey(renderContext, key);
        moduleParams.put("finalKey", (Serializable)((Object)finalKey));
        LinkedList<String> userKeysLinkedList = userKeys.get();
        if (userKeysLinkedList == null) {
            userKeysLinkedList = new LinkedList();
            userKeys.set(userKeysLinkedList);
        }
        if (userKeysLinkedList.contains(finalKey)) {
            userKeysLinkedList.add(0, EMPTY_USERKEY);
            this.getFragmentGenerationPermit(finalKey, renderContext.getRequest());
            return null;
        }
        userKeysLinkedList.add(0, finalKey);
        if (Boolean.TRUE.equals(forceGeneration)) {
            this.getFragmentGenerationPermit(finalKey, renderContext.getRequest());
            return null;
        }
        if (!this.isCacheable(renderContext, resource, key, properties) || this.bypassCache(renderContext, resource)) {
            this.getFragmentGenerationPermit(finalKey, renderContext.getRequest());
            return null;
        }
        Element element = null;
        Cache cache = this.cacheProvider.getCache();
        try {
            if (debugEnabled) {
                logger.debug("Try to get content from cache for node with final key: {}", (Object)finalKey);
            }
            element = cache.get((Serializable)((Object)finalKey));
        }
        catch (LockTimeoutException e) {
            logger.warn("Error while rendering " + renderContext.getMainResource() + e.getMessage(), (Throwable)e);
        }
        if (element != null && element.getObjectValue() != null) {
            return this.returnFromCache(renderContext, resource, key, finalKey, element, cache);
        }
        CountDownLatch countDownLatch = this.avoidParallelProcessingOfSameModule(finalKey, renderContext, resource, properties);
        if (countDownLatch == null) {
            element = cache.get((Serializable)((Object)finalKey));
            if (element != null && element.getObjectValue() != null) {
                return this.returnFromCache(renderContext, resource, key, finalKey, element, cache);
            }
        } else {
            Set<CountDownLatch> latches = processingLatches.get();
            if (latches == null) {
                latches = new HashSet<CountDownLatch>();
                processingLatches.set(latches);
            }
            latches.add(countDownLatch);
        }
        return null;
    }

    protected boolean isCacheable(RenderContext renderContext, Resource resource, String key, Properties properties) throws RepositoryException {
        if (notCacheableFragment.containsKey(key)) {
            return false;
        }
        String cacheExpiration = properties.getProperty(CACHE_EXPIRATION);
        Long expiration = cacheExpiration != null ? Long.parseLong(cacheExpiration) : -1L;
        return expiration != 0L;
    }

    private boolean bypassCache(RenderContext renderContext, Resource resource) throws RepositoryException {
        if (renderContext.getRequest().getParameter(V) != null && renderContext.isLoggedIn()) {
            return true;
        }
        String ecParameter = renderContext.getRequest().getParameter(EC);
        if (ecParameter != null) {
            if (ecParameter.equals(resource.getNode().getIdentifier())) {
                return true;
            }
            for (Resource parent : renderContext.getResourcesStack()) {
                if (!ecParameter.equals(parent.getNode().getIdentifier())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean useDependencies() {
        return true;
    }

    protected String returnFromCache(RenderContext renderContext, Resource resource, String key, String finalKey, Element element, Cache cache) throws RenderException {
        boolean displayCacheInfo;
        HashSet<String> servedFromCache;
        if (logger.isDebugEnabled()) {
            logger.debug("Content retrieved from cache for node with key: {}", (Object)finalKey);
        }
        CacheEntry cacheEntry = (CacheEntry)element.getObjectValue();
        String cachedContent = (String)cacheEntry.getObject();
        this.restorePropertiesFromCacheEntry(cacheEntry, renderContext);
        cachedContent = this.aggregateContent(cache, cachedContent, renderContext, (String)cacheEntry.getProperty("areaResource"), new Stack<String>(), (Set)cacheEntry.getProperty("allPaths"));
        if (renderContext.getMainResource() == resource) {
            cachedContent = AggregateCacheFilter.removeCacheTags(cachedContent);
        }
        if ((servedFromCache = (HashSet<String>)renderContext.getRequest().getAttribute("servedFromCache")) == null) {
            servedFromCache = new HashSet<String>();
            renderContext.getRequest().setAttribute("servedFromCache", servedFromCache);
        }
        servedFromCache.add(finalKey);
        boolean bl = displayCacheInfo = SettingsBean.getInstance().isDevelopmentMode() && Boolean.valueOf(renderContext.getRequest().getParameter("cacheinfo")) != false;
        if (displayCacheInfo && !cachedContent.contains("<body") && cachedContent.trim().length() > 0) {
            return this.appendDebugInformation(renderContext, key, cachedContent, element);
        }
        return cachedContent;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        return this.execute(previousOut, renderContext, resource, chain, false);
    }

    private String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain, boolean bypassDependencies) throws Exception {
        boolean displayCacheInfo;
        Properties properties = this.getAttributesForKey(renderContext, resource);
        if (!bypassDependencies) {
            resource.getDependencies().add(resource.getNode().getCanonicalPath());
            if ("true".equals(properties.getProperty("cache.mainResource"))) {
                resource.getDependencies().add(renderContext.getMainResource().getNode().getCanonicalPath());
            }
        }
        String key = (String)((Object)resource.getModuleParams().remove("cacheKey"));
        String storedFinalKey = (String)((Object)resource.getModuleParams().remove("finalKey"));
        String generatedKey = this.cacheProvider.getKeyGenerator().generate(resource, renderContext, properties);
        if (!generatedKey.equals(key)) {
            logger.warn("Key generation does not give the same result after execution  , was {} , now is {}", (Object)key, (Object)generatedKey);
            return previousOut;
        }
        String finalKey = this.replacePlaceholdersInCacheKey(renderContext, key);
        if (!finalKey.equals(storedFinalKey)) {
            logger.warn("Key generation after replacement does not give the same result after execution , was {} , now is {}", (Object)storedFinalKey, (Object)finalKey);
            return previousOut;
        }
        Set servedFromCache = (Set)renderContext.getRequest().getAttribute("servedFromCache");
        if (servedFromCache != null && servedFromCache.contains(finalKey)) {
            return previousOut;
        }
        boolean cacheable = this.isCacheable(renderContext, resource, key, properties);
        boolean debugEnabled = logger.isDebugEnabled();
        boolean bl = displayCacheInfo = SettingsBean.getInstance().isDevelopmentMode() && Boolean.valueOf(renderContext.getRequest().getParameter("cacheinfo")) != false;
        if (cacheable) {
            if (!this.bypassCache(renderContext, resource)) {
                Cache cache = this.cacheProvider.getCache();
                if (debugEnabled) {
                    logger.debug("Caching content for final key : {}", (Object)finalKey);
                }
                this.doCache(previousOut, renderContext, resource, properties, cache, key, finalKey, bypassDependencies);
            }
        } else {
            notCacheableFragment.put(key, Boolean.TRUE);
        }
        if (displayCacheInfo && !previousOut.contains("<body") && previousOut.trim().length() > 0) {
            return this.appendDebugInformation(renderContext, key, this.surroundWithCacheTag(key, previousOut), null);
        }
        if (renderContext.getMainResource() == resource) {
            return AggregateCacheFilter.removeCacheTags(previousOut);
        }
        return this.surroundWithCacheTag(key, previousOut);
    }

    protected void doCache(String previousOut, RenderContext renderContext, Resource resource, Properties properties, Cache cache, String key, String finalKey) throws RepositoryException, ParseException {
        this.doCache(previousOut, renderContext, resource, properties, cache, key, finalKey, false);
    }

    protected void doCache(String previousOut, RenderContext renderContext, Resource resource, Properties properties, Cache cache, String key, String finalKey, boolean bypassDependencies) throws RepositoryException, ParseException {
        Long expiration = Long.parseLong(properties.getProperty(CACHE_EXPIRATION));
        Set<String> depNodeWrappers = Collections.emptySet();
        CacheEntry<String> cacheEntry = this.createCacheEntry(previousOut, renderContext, resource, key);
        this.addPropertiesToCacheEntry(resource, cacheEntry, renderContext);
        Element cachedElement = new Element((Serializable)((Object)finalKey), cacheEntry);
        if (expiration > 0L) {
            this.addExpirationToCacheElements(cache, finalKey, expiration, cachedElement);
        }
        if (!bypassDependencies) {
            this.storeDependencies(renderContext, resource, finalKey, depNodeWrappers);
        }
        cache.put(cachedElement);
        if (logger.isDebugEnabled()) {
            logger.debug("Store in cache content of node with key: {}", (Object)finalKey);
            StringBuilder stringBuilder = new StringBuilder();
            for (String path : depNodeWrappers) {
                stringBuilder.append(path).append("\n");
            }
            logger.debug("Dependencies of {}: {}", (Object)finalKey, (Object)stringBuilder);
        }
    }

    private void addExpirationToCacheElements(Cache cache, String finalKey, Long expiration, Element cachedElement) throws ParseException {
        cachedElement.setTimeToLive(expiration.intValue());
    }

    private void storeDependencies(RenderContext renderContext, Resource resource, String finalKey, Set<String> depNodeWrappers) {
        if (this.useDependencies()) {
            Cache dependenciesCache = this.cacheProvider.getDependenciesCache();
            depNodeWrappers = resource.getDependencies();
            for (String path : depNodeWrappers) {
                if (path.startsWith("/modules")) continue;
                this.storeDependency(renderContext, finalKey, dependenciesCache, path);
            }
            Cache regexpDependenciesCache = this.cacheProvider.getRegexpDependenciesCache();
            Set<String> regexpDepNodeWrappers = resource.getRegexpDependencies();
            for (String regexp : regexpDepNodeWrappers) {
                this.storeDependency(renderContext, finalKey, regexpDependenciesCache, regexp);
            }
        }
        resource.getDependencies().clear();
        resource.getRegexpDependencies().clear();
    }

    private void storeDependency(RenderContext renderContext, String finalKey, Cache dependenciesCache, String path) {
        Set<String> dependencies;
        Element element1 = dependenciesCache.get((Serializable)((Object)path));
        Set<String> set = dependencies = element1 != null ? (Set<String>)element1.getObjectValue() : Collections.newSetFromMap(new ConcurrentHashMap());
        if (!dependencies.contains(ALL)) {
            if (dependencies.size() + 1 > this.dependenciesLimit) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Dependencies limit exceeded by path {}: {}/{}", new Object[]{path, dependencies.size(), this.dependenciesLimit});
                }
                Element element = new Element((Object)path, ALL_SET);
                element.setEternal(true);
                dependenciesCache.put(element);
            } else {
                this.addDependencies(renderContext, finalKey, dependenciesCache, path, dependencies);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getAttributesForKey(RenderContext renderContext, Resource resource) throws RepositoryException {
        String requestParameters;
        Script script = resource.getScript(renderContext);
        JCRNodeWrapper node = resource.getNode();
        boolean isBound = node.isNodeType("jmix:bindedComponent");
        boolean isList = node.isNodeType("jmix:list");
        Properties properties = new Properties();
        if (script != null) {
            properties.putAll((Map<?, ?>)script.getView().getDefaultProperties());
            properties.putAll((Map<?, ?>)script.getView().getProperties());
        }
        if (isList) {
            Resource listLoader = new Resource(node, resource.getTemplateType(), "hidden.load", "include");
            try {
                Script s = this.service.resolveScript(listLoader, renderContext);
                properties.putAll((Map<?, ?>)s.getView().getProperties());
            }
            catch (TemplateNotFoundException e) {
                logger.error("Cannot find loader script for list " + node.getPath(), (Throwable)e);
            }
        }
        if (node.hasProperty(PER_USER)) {
            properties.put(CACHE_PER_USER, node.getProperty(PER_USER).getString());
        }
        if (isBound) {
            properties.put("cache.mainResource", "true");
        }
        StringBuilder updatedRequestParameters = !StringUtils.isEmpty((String)(requestParameters = properties.getProperty("cache.requestParameters"))) ? new StringBuilder(requestParameters + ",ec,v") : new StringBuilder("ec,v");
        if (SettingsBean.getInstance().isDevelopmentMode()) {
            updatedRequestParameters.append(",cacheinfo,moduleinfo");
        }
        properties.put("cache.requestParameters", updatedRequestParameters.toString());
        String viewExpiration = properties.getProperty(CACHE_EXPIRATION);
        Object requestExpiration = renderContext.getRequest().getAttribute("expiration");
        if (requestExpiration != null) {
            properties.put(CACHE_EXPIRATION, requestExpiration);
        } else if (node.hasProperty("j:expiration")) {
            properties.put(CACHE_EXPIRATION, node.getProperty("j:expiration").getString());
        } else if (viewExpiration != null) {
            properties.put(CACHE_EXPIRATION, viewExpiration);
        } else {
            properties.put(CACHE_EXPIRATION, "-1");
        }
        String propertiesScript = properties.getProperty("cache.propertiesScript");
        if (propertiesScript != null) {
            Resource props = new Resource(node, resource.getTemplateType(), propertiesScript, "include");
            try {
                Script s = this.service.resolveScript(props, renderContext);
                try {
                    renderContext.getRequest().setAttribute("cacheProperties", (Object)properties);
                    s.execute(props, renderContext);
                }
                catch (RenderException e) {
                    logger.error("Cannot execute script", (Throwable)e);
                }
                finally {
                    renderContext.getRequest().removeAttribute("cacheProperties");
                }
            }
            catch (TemplateNotFoundException e) {
                logger.error("Cannot find cache properties script " + propertiesScript + " for the node " + node.getPath(), (Throwable)e);
            }
        }
        return properties;
    }

    protected CacheEntry<String> createCacheEntry(String previousOut, RenderContext renderContext, Resource resource, String key) {
        String out = TextUtils.replaceBoundedString(previousOut, CACHE_TAG_START_1_NOSRC, CACHE_TAG_END, GENERATOR);
        StringBuilder sb = new StringBuilder(out.length() + key.length() + CACHE_TAG_LENGTH);
        sb.append(out);
        this.surroundWithCacheTag(key, sb);
        return new CacheEntry<String>(sb.toString());
    }

    private void addPropertiesToCacheEntry(Resource resource, CacheEntry<String> cacheEntry, RenderContext renderContext) throws RepositoryException {
        if (resource.getNode().isNodeType("jnt:area") || resource.getNode().isNodeType("jnt:mainResourceDisplay")) {
            cacheEntry.setProperty("areaResource", (Serializable)((Object)resource.getNode().getIdentifier()));
        }
        TreeSet<String> allPaths = new TreeSet<String>();
        allPaths.addAll(renderContext.getRenderedPaths());
        Map m = (Map)renderContext.getRequest().getAttribute("moduleMap");
        if (m != null && m.containsKey("requestAttributesToCache")) {
            HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
            Collection requestAttributesToCache = (Collection)m.get("requestAttributesToCache");
            for (String attributesToCache : requestAttributesToCache) {
                if (!(renderContext.getRequest().getAttribute(attributesToCache) instanceof Serializable)) continue;
                attributes.put(attributesToCache, (Serializable)renderContext.getRequest().getAttribute(attributesToCache));
            }
            cacheEntry.setProperty("requestAttributes", attributes);
        }
        cacheEntry.setProperty("allPaths", allPaths);
    }

    protected void addDependencies(RenderContext renderContext, String finalKey, Cache cache, String value, Set<String> newDependencies) {
        if (newDependencies.add(finalKey)) {
            cache.put(new Element((Object)value, newDependencies));
        }
    }

    protected String replacePlaceholdersInCacheKey(RenderContext renderContext, String key) {
        return this.cacheProvider.getKeyGenerator().replacePlaceholdersInCacheKey(renderContext, key);
    }

    private int replaceInContent(StringBuilder sb, int start, int end, String replacement) {
        if (replacement == null) {
            replacement = EMPTY_USERKEY;
        }
        sb.replace(start, end, replacement);
        return sb.indexOf(CACHE_ESI_TAG_START, start + replacement.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String aggregateContent(Cache cache, String cachedContent, RenderContext renderContext, String areaIdentifier, Stack<String> cacheKeyStack, Set<String> allPaths) throws RenderException {
        int esiTagStartIndex = cachedContent.indexOf(CACHE_ESI_TAG_START);
        if (esiTagStartIndex == -1) {
            return cachedContent;
        }
        StringBuilder sb = new StringBuilder(cachedContent);
        while (esiTagStartIndex != -1) {
            int esiTagEndIndex = sb.indexOf(CACHE_ESI_TAG_END, esiTagStartIndex);
            if (esiTagEndIndex != -1) {
                String cacheKey = sb.substring(esiTagStartIndex + CACHE_ESI_TAG_START.length(), esiTagEndIndex);
                String replacedCacheKey = this.replacePlaceholdersInCacheKey(renderContext, cacheKey);
                if (logger.isDebugEnabled()) {
                    logger.debug("Check if {} is in cache", (Object)replacedCacheKey);
                }
                boolean cacheable = true;
                CacheKeyGenerator keyGenerator = this.cacheProvider.getKeyGenerator();
                Map<String, String> keyAttrbs = keyGenerator.parse(cacheKey);
                String ecParameter = renderContext.getRequest().getParameter(EC);
                if (ecParameter != null && ecParameter.equals(keyAttrbs.get("resourceID")) || renderContext.getRequest().getParameter(V) != null && renderContext.isLoggedIn()) {
                    cacheable = false;
                }
                if (cacheable && cache.isKeyInCache((Object)replacedCacheKey)) {
                    Element element = cache.get((Serializable)((Object)replacedCacheKey));
                    if (element != null && element.getObjectValue() != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("It has been found in cache");
                        }
                        CacheEntry cacheEntry = (CacheEntry)element.getObjectValue();
                        String content = (String)cacheEntry.getObject();
                        if (cacheKeyStack.contains(cacheKey)) {
                            esiTagStartIndex = this.replaceInContent(sb, esiTagStartIndex, esiTagEndIndex + CACHE_ESI_TAG_END_LENGTH, EMPTY_USERKEY);
                            continue;
                        }
                        cacheKeyStack.push(cacheKey);
                        try {
                            if (!cachedContent.equals(content)) {
                                try {
                                    this.restorePropertiesFromCacheEntry(cacheEntry, renderContext);
                                    esiTagStartIndex = this.replaceInContent(sb, esiTagStartIndex, esiTagEndIndex + CACHE_ESI_TAG_END_LENGTH, this.aggregateContent(cache, content, renderContext, (String)cacheEntry.getProperty("areaResource"), cacheKeyStack, (Set)cacheEntry.getProperty("allPaths")));
                                    continue;
                                }
                                catch (RenderException e) {
                                    throw new RuntimeException(e.getMessage(), e);
                                }
                            }
                            esiTagStartIndex = this.replaceInContent(sb, esiTagStartIndex, esiTagEndIndex + CACHE_ESI_TAG_END_LENGTH, content);
                            continue;
                        }
                        finally {
                            cacheKeyStack.pop();
                            continue;
                        }
                    }
                    cache.put(new Element((Serializable)((Object)replacedCacheKey), null));
                    if (logger.isDebugEnabled()) {
                        logger.debug("Content is expired");
                    }
                    try {
                        esiTagStartIndex = this.replaceInContent(sb, esiTagStartIndex, esiTagEndIndex + CACHE_ESI_TAG_END_LENGTH, this.generateContent(renderContext, cacheKey, areaIdentifier, allPaths));
                        continue;
                    }
                    catch (RenderException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Content is missing from cache");
                }
                try {
                    esiTagStartIndex = this.replaceInContent(sb, esiTagStartIndex, esiTagEndIndex + CACHE_ESI_TAG_END_LENGTH, this.generateContent(renderContext, cacheKey, areaIdentifier, allPaths));
                    continue;
                }
                catch (RenderException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return sb.toString();
        }
        return sb.toString();
    }

    private void restorePropertiesFromCacheEntry(CacheEntry<?> cacheEntry, RenderContext renderContext) {
        if (cacheEntry.getProperty("requestAttributes") != null) {
            Map requestAttributesToCache = (Map)cacheEntry.getProperty("requestAttributes");
            for (Map.Entry entry : requestAttributesToCache.entrySet()) {
                renderContext.getRequest().setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
    }

    protected String generateContent(RenderContext renderContext, String cacheKey, String areaIdentifier, Set<String> allPaths) throws RenderException {
        this.getFragmentGenerationPermit(cacheKey, renderContext.getRequest());
        CacheKeyGenerator cacheKeyGenerator = this.cacheProvider.getKeyGenerator();
        try {
            Map<String, String> keyAttrbs = cacheKeyGenerator.parse(cacheKey);
            JCRSessionWrapper currentUserSession = JCRSessionFactory.getInstance().getCurrentUserSession(renderContext.getWorkspace(), LanguageCodeConverters.languageCodeToLocale(keyAttrbs.get("language")), renderContext.getFallbackLocale());
            JCRNodeWrapper node = null;
            try {
                node = currentUserSession.getNode(StringUtils.replace((String)keyAttrbs.get("path"), (String)"_mr_", (String)EMPTY_USERKEY));
            }
            catch (PathNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Node {} is no longer available. Replacing output with empty content.", (Object)keyAttrbs.get("path"));
                }
                return EMPTY_USERKEY;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Calling render service for generating content for key " + cacheKey + " with attributes :  areaIdentifier " + areaIdentifier);
            }
            renderContext.getRequest().removeAttribute("areaNodeTypesRestriction" + renderContext.getRequest().getAttribute("org.jahia.modules.level"));
            Template oldOne = (Template)renderContext.getRequest().getAttribute("previousTemplate");
            String context = keyAttrbs.get("context");
            if (!context.equals("page")) {
                renderContext.getRequest().setAttribute("templateSet", (Object)Boolean.TRUE);
            }
            if (!StringUtils.isEmpty((String)keyAttrbs.get("templateNodes"))) {
                Template templateNodes = new Template(keyAttrbs.get("templateNodes"));
                renderContext.getRequest().setAttribute("previousTemplate", (Object)templateNodes);
            } else {
                renderContext.getRequest().removeAttribute("previousTemplate");
            }
            HashSet<String> addedPath = new HashSet<String>();
            if (null != allPaths && !allPaths.isEmpty()) {
                for (String path : allPaths) {
                    if (renderContext.getRenderedPaths().contains(path)) continue;
                    renderContext.getRenderedPaths().add(path);
                    addedPath.add(path);
                }
            }
            renderContext.getRequest().setAttribute("skipWrapper", (Object)Boolean.TRUE);
            Object oldInArea = renderContext.getRequest().getAttribute("inArea");
            String inArea = keyAttrbs.get("inArea");
            if (StringUtils.isEmpty((String)inArea)) {
                renderContext.getRequest().removeAttribute("inArea");
            } else {
                renderContext.getRequest().setAttribute("inArea", (Object)Boolean.valueOf(inArea));
            }
            if (areaIdentifier != null) {
                renderContext.getRequest().setAttribute("areaListResource", (Object)currentUserSession.getNodeByIdentifier(areaIdentifier));
            } else {
                renderContext.getRequest().removeAttribute("areaListResource");
            }
            Resource resource = new Resource(node, keyAttrbs.get("templateType"), keyAttrbs.get("template"), context);
            String params = keyAttrbs.get("moduleParams");
            if (StringUtils.isNotEmpty((String)params)) {
                try {
                    JSONObject map = new JSONObject(ModuleParamsCacheKeyPartGenerator.decodeString(params));
                    Iterator keys = map.keys();
                    while (keys.hasNext()) {
                        String next = (String)keys.next();
                        resource.getModuleParams().put(next, (Serializable)map.get(next));
                    }
                }
                catch (JSONException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            resource.getModuleParams().put("cache.forceGeneration", Boolean.valueOf(true));
            String content = RenderService.getInstance().render(resource, renderContext);
            if (StringUtils.isBlank((String)content) && renderContext.getRedirect() == null) {
                logger.error("Empty generated content for key " + cacheKey + " with attributes :  areaIdentifier " + areaIdentifier);
            }
            for (String s : addedPath) {
                renderContext.getRenderedPaths().remove(s);
            }
            if (oldInArea != null) {
                renderContext.getRequest().setAttribute("inArea", oldInArea);
            } else {
                renderContext.getRequest().removeAttribute("inArea");
            }
            if (oldOne != null) {
                renderContext.getRequest().setAttribute("previousTemplate", (Object)oldOne);
            } else {
                renderContext.getRequest().removeAttribute("previousTemplate");
            }
            return content;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return EMPTY_USERKEY;
        }
    }

    protected String surroundWithCacheTag(String key, String output) {
        StringBuilder builder = new StringBuilder(output.length() + key.length() + CACHE_TAG_LENGTH);
        builder.append(output);
        this.surroundWithCacheTag(key, builder);
        return builder.toString();
    }

    protected void surroundWithCacheTag(String key, StringBuilder output) {
        output.insert(0, CACHE_TAG_START_2).insert(0, key).insert(0, CACHE_TAG_START_1).append(CACHE_TAG_END);
    }

    protected String appendDebugInformation(RenderContext renderContext, String key, String renderContent, Element cachedElement) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class=\"cacheDebugInfo\">");
        stringBuilder.append("<span class=\"cacheDebugInfoLabel\">Expiration: </span><span>");
        String key1 = this.replacePlaceholdersInCacheKey(renderContext, key);
        if (!notCacheableFragment.containsKey(key)) {
            stringBuilder.append(SimpleDateFormat.getDateTimeInstance().format(new Date(this.cacheProvider.getCache().get((Serializable)((Object)key1)).getExpirationTime())));
        } else {
            stringBuilder.append("Not cached fragment ").append(SimpleDateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime()));
        }
        stringBuilder.append("</span><br/>");
        stringBuilder.append("</div>");
        stringBuilder.append(renderContent);
        return stringBuilder.toString();
    }

    public static String removeEsiTags(String content) {
        return AggregateCacheFilter.removeCacheTags(content);
    }

    public static String removeCacheTags(String content) {
        if (StringUtils.isNotEmpty((String)content)) {
            return CLEANUP_REGEXP.matcher(content).replaceAll(EMPTY_USERKEY);
        }
        return content;
    }

    @Override
    public String getContentForError(RenderContext renderContext, Resource resource, RenderChain chain, Exception e) {
        super.getContentForError(renderContext, resource, chain, e);
        if (this.cascadeFragmentErrors || "page".equals(resource.getContextConfiguration())) {
            return null;
        }
        try {
            renderContext.getRequest().setAttribute("expiration", (Object)Integer.toString(this.errorCacheExpiration));
            Properties properties = this.getAttributesForKey(renderContext, resource);
            String key = this.cacheProvider.getKeyGenerator().generate(resource, renderContext, properties);
            String finalKey = this.replacePlaceholdersInCacheKey(renderContext, key);
            Element element = null;
            Cache cache = this.cacheProvider.getCache();
            try {
                element = cache.get((Serializable)((Object)finalKey));
            }
            catch (LockTimeoutException ex) {
                logger.warn("Error while rendering " + renderContext.getMainResource() + ex.getMessage(), (Throwable)ex);
            }
            if (element != null && element.getObjectValue() != null) {
                return this.returnFromCache(renderContext, resource, key, finalKey, element, cache);
            }
            return this.execute("<!-- Module error : " + HtmlUtils.htmlEscape((String)e.getMessage()) + "-->", renderContext, resource, chain, true);
        }
        catch (Exception e1) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalize(RenderContext renderContext, Resource resource, RenderChain chain) {
        LinkedList<String> userKeysLinkedList = userKeys.get();
        if (userKeysLinkedList != null && !userKeysLinkedList.isEmpty()) {
            String finalKey = userKeysLinkedList.remove(0);
            if (userKeysLinkedList.isEmpty()) {
                this.releaseFragmentGenerationPermit(renderContext.getRequest());
            }
            Set<CountDownLatch> latches = processingLatches.get();
            Map<String, CountDownLatch> countDownLatchMap = this.generatorQueue.getGeneratingModules();
            CountDownLatch latch = countDownLatchMap.get(finalKey);
            if (latches != null && latches.contains(latch)) {
                latch.countDown();
                Map<String, CountDownLatch> map = countDownLatchMap;
                synchronized (map) {
                    latches.remove(countDownLatchMap.remove(finalKey));
                }
            }
        }
    }

    private void getFragmentGenerationPermit(String key, HttpServletRequest request) {
        if (!Boolean.TRUE.equals(request.getAttribute(HAS_PROCESSING_SEMAPHORE_PARAM))) {
            try {
                if (!this.generatorQueue.getAvailableProcessings().tryAcquire(this.generatorQueue.getModuleGenerationWaitTime(), TimeUnit.MILLISECONDS)) {
                    this.manageThreadDump();
                    StringBuilder errorMsgBuilder = new StringBuilder(512);
                    errorMsgBuilder.append("Module generation takes too long due to maximum parallel processing reached (").append(this.generatorQueue.getMaxModulesToGenerateInParallel()).append(") - ").append(key).append(" - ").append(request.getRequestURI());
                    throw new JahiaServiceUnavailableException(errorMsgBuilder.toString());
                }
                request.setAttribute(HAS_PROCESSING_SEMAPHORE_PARAM, (Object)Boolean.TRUE);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new JahiaRuntimeException(ie);
            }
        }
    }

    private void releaseFragmentGenerationPermit(HttpServletRequest request) {
        if (Boolean.TRUE.equals(request.getAttribute(HAS_PROCESSING_SEMAPHORE_PARAM))) {
            this.generatorQueue.getAvailableProcessings().release();
            request.removeAttribute(HAS_PROCESSING_SEMAPHORE_PARAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CountDownLatch avoidParallelProcessingOfSameModule(String key, RenderContext renderContext, Resource resource, Properties properties) throws RepositoryException {
        HttpServletRequest request = renderContext.getRequest();
        CountDownLatch latch = null;
        boolean mustWait = true;
        Map<String, CountDownLatch> generatingModules = this.generatorQueue.getGeneratingModules();
        if (generatingModules.get(key) == null) {
            this.getFragmentGenerationPermit(key, request);
        }
        if (this.shouldUseLatch(resource, properties)) {
            Map<String, CountDownLatch> map = generatingModules;
            synchronized (map) {
                latch = generatingModules.get(key);
                if (latch == null) {
                    latch = new CountDownLatch(1);
                    generatingModules.put(key, latch);
                    mustWait = false;
                }
            }
        } else {
            mustWait = false;
        }
        if (mustWait) {
            this.releaseFragmentGenerationPermit(request);
            try {
                if (!latch.await(this.generatorQueue.getModuleGenerationWaitTime(), TimeUnit.MILLISECONDS)) {
                    this.manageThreadDump();
                    StringBuilder errorMsgBuilder = new StringBuilder(512);
                    errorMsgBuilder.append("Module generation takes too long due to module not generated fast enough (>").append(this.generatorQueue.getModuleGenerationWaitTime()).append(" ms)- ").append(key).append(" - ").append(request.getRequestURI());
                    renderContext.getRenderedPaths().remove(resource.getNode().getPath());
                    throw new JahiaServiceUnavailableException(errorMsgBuilder.toString());
                }
                latch = null;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new JahiaRuntimeException(ie);
            }
        }
        return latch;
    }

    private boolean shouldUseLatch(Resource resource, Properties properties) throws RepositoryException {
        if (!StringUtils.isEmpty((String)properties.getProperty("cache.latch"))) {
            return Boolean.valueOf(properties.getProperty("cache.latch"));
        }
        if (this.skipLatchForConfigurations != null && this.skipLatchForConfigurations.contains(resource.getContextConfiguration())) {
            return false;
        }
        if (this.skipLatchForPaths != null) {
            for (String skipLatchForPath : this.skipLatchForPaths) {
                if (skipLatchForPath.contains("$currentSite")) {
                    skipLatchForPath = skipLatchForPath.replace("$currentSite", resource.getNode().getResolveSite().getPath());
                }
                if (!resource.getNode().getPath().startsWith(skipLatchForPath)) continue;
                return false;
            }
        }
        if (this.skipLatchForNodeTypes != null) {
            for (String nodeType : this.skipLatchForNodeTypes) {
                if (!resource.getNode().isNodeType(nodeType)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void manageThreadDump() {
        boolean createDump = false;
        long minInterval = this.generatorQueue.getMinimumIntervalAfterLastAutoThreadDump();
        if (minInterval > -1L && (this.generatorQueue.isThreadDumpToSystemOut() || this.generatorQueue.isThreadDumpToFile())) {
            long now = System.currentTimeMillis();
            Byte[] byteArray = this.threadDumpCheckLock;
            // MONITORENTER : this.threadDumpCheckLock
            if (now > lastThreadDumpTime + minInterval) {
                createDump = true;
                lastThreadDumpTime = now;
            }
            // MONITOREXIT : byteArray
        }
        if (!createDump) return;
        ThreadMonitor tm = ThreadMonitor.getInstance();
        tm.dumpThreadInfo(this.generatorQueue.isThreadDumpToSystemOut(), this.generatorQueue.isThreadDumpToFile());
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        AggregateCacheFilter.flushNotCacheableFragment();
    }

    public void removeNotCacheableFragment(String key) {
        CacheKeyGenerator keyGenerator = this.cacheProvider.getKeyGenerator();
        if (keyGenerator instanceof DefaultCacheKeyGenerator) {
            DefaultCacheKeyGenerator defaultCacheKeyGenerator = (DefaultCacheKeyGenerator)keyGenerator;
            Map<String, String> keyAttrbs = defaultCacheKeyGenerator.parse(key);
            String path = keyAttrbs.get("path");
            ArrayList<String> removableKeys = new ArrayList<String>();
            for (String notCacheableKey : notCacheableFragment.keySet()) {
                if (!notCacheableKey.contains(path)) continue;
                removableKeys.add(notCacheableKey);
            }
            for (String removableKey : removableKeys) {
                notCacheableFragment.remove(removableKey);
            }
        }
    }

    public static void flushNotCacheableFragment() {
        notCacheableFragment.clear();
    }
}

