/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Stack;
import javax.jcr.RepositoryException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateFilter
extends AbstractFilter {
    private static final Logger logger = LoggerFactory.getLogger(AggregateFilter.class);
    private static final String ESI_TAG_START = "<jahia_esi:include src=\"";
    private static final String ESI_TAG_END = "\"></jahia_esi:include>";
    private static final int ESI_TAG_END_LENGTH = "\"></jahia_esi:include>".length();
    private static final String RENDERING_TIMER = "aggregateFilter.rendering.timer";
    public static final String RENDERING_KEY = "aggregateFilter.rendering.key";
    public static final String RENDERING_FINAL_KEY = "aggregateFilter.rendering.final.key";
    public static final String AGGREGATING_KEY = "aggregateFilter.aggregating.key";
    public static final String AGGREGATING = "aggregateFilter.aggregating";
    public static final String RESOURCES_STACK = "aggregateFilter.resourcesStack";
    public static final String SKIP_AGGREGATION = "aggregateFilter.skip";
    private CacheKeyGenerator keyGenerator;

    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        String key;
        if (AggregateFilter.skipAggregation((ServletRequest)renderContext.getRequest())) {
            return null;
        }
        HttpServletRequest request = renderContext.getRequest();
        boolean aggregating = resource.getModuleParams().get(AGGREGATING_KEY) != null;
        boolean isPageResource = "page".equals(resource.getContextConfiguration());
        if (!isPageResource && request.getAttribute(RESOURCES_STACK) == null) {
            return null;
        }
        String string = key = aggregating ? (String)((Object)resource.getModuleParams().remove(AGGREGATING_KEY)) : this.keyGenerator.generate(resource, renderContext, this.keyGenerator.getAttributesForKey(renderContext, resource));
        if (isPageResource || aggregating) {
            String finalKey = this.keyGenerator.replacePlaceholdersInCacheKey(renderContext, key);
            if (isPageResource) {
                request.setAttribute(RESOURCES_STACK, new Stack());
            } else {
                Stack resourcesStack = (Stack)request.getAttribute(RESOURCES_STACK);
                if (resourcesStack.contains(resource)) {
                    logger.warn("Loop detected while rendering resource {}. Please check your content structure and references.", (Object)resource.getPath());
                    if (!"live".equals(renderContext.getMode())) {
                        return MessageFormat.format(Messages.getInternal("label.render.loop", renderContext.getUILocale()), resource.getPath());
                    }
                    return "";
                }
                resourcesStack.push(resource);
            }
            Map moduleMap = (Map)request.getAttribute("moduleMap");
            moduleMap.put(RENDERING_KEY, key);
            moduleMap.put(RENDERING_FINAL_KEY, finalKey);
            moduleMap.put(RENDERING_TIMER, System.currentTimeMillis());
            moduleMap.put(AGGREGATING, aggregating);
            logger.debug("Rendering fragment {} with key {}", (Object)resource.getPath(), (Object)key);
            return null;
        }
        return ESI_TAG_START + key + ESI_TAG_END;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (AggregateFilter.skipAggregation((ServletRequest)renderContext.getRequest())) {
            return previousOut;
        }
        HttpServletRequest request = renderContext.getRequest();
        if (request.getAttribute(RESOURCES_STACK) == null) {
            return previousOut;
        }
        Map moduleMap = (Map)request.getAttribute("moduleMap");
        if ("page".equals(resource.getContextConfiguration()) || moduleMap.get(AGGREGATING) == Boolean.TRUE) {
            if (logger.isDebugEnabled()) {
                long start = (Long)moduleMap.get(RENDERING_TIMER);
                logger.debug("Rendered fragment for {} took {} ms.", (Object)resource.getPath(), (Object)(System.currentTimeMillis() - start));
            }
            return this.aggregateContent(previousOut, renderContext);
        }
        return previousOut;
    }

    @Override
    public void finalize(RenderContext renderContext, Resource resource, RenderChain renderChain) {
        Map moduleMap;
        if (AggregateFilter.skipAggregation((ServletRequest)renderContext.getRequest())) {
            return;
        }
        HttpServletRequest request = renderContext.getRequest();
        if (request.getAttribute(RESOURCES_STACK) == null) {
            return;
        }
        if ("page".equals(resource.getContextConfiguration())) {
            request.removeAttribute(RESOURCES_STACK);
        }
        if ((moduleMap = (Map)request.getAttribute("moduleMap")).get(AGGREGATING) == Boolean.TRUE) {
            Stack keysStack = (Stack)request.getAttribute(RESOURCES_STACK);
            keysStack.pop();
        }
    }

    protected String aggregateContent(String content, RenderContext renderContext) throws RenderException {
        int esiTagStartIndex = content.indexOf(ESI_TAG_START);
        if (esiTagStartIndex == -1) {
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        while (esiTagStartIndex != -1) {
            int esiTagEndIndex = sb.indexOf(ESI_TAG_END, esiTagStartIndex);
            if (esiTagEndIndex != -1) {
                String replacement = this.generateContent(renderContext, sb.substring(esiTagStartIndex + ESI_TAG_START.length(), esiTagEndIndex));
                if (replacement == null) {
                    replacement = "";
                }
                sb.replace(esiTagStartIndex, esiTagEndIndex + ESI_TAG_END_LENGTH, replacement);
                esiTagStartIndex = sb.indexOf(ESI_TAG_START, esiTagStartIndex + replacement.length());
                continue;
            }
            return sb.toString();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateContent(RenderContext renderContext, String key) throws RenderException {
        try {
            String content;
            Map<String, String> keyAttrs = this.keyGenerator.parse(key);
            String path = StringUtils.replace((String)keyAttrs.get("path"), (String)"_mr_", (String)"");
            JCRSessionWrapper currentUserSession = JCRSessionFactory.getInstance().getCurrentUserSession(renderContext.getWorkspace(), LanguageCodeConverters.languageCodeToLocale(keyAttrs.get("language")), renderContext.getFallbackLocale());
            String canonicalPath = keyAttrs.get("canonicalPath");
            canonicalPath = StringUtils.isEmpty((String)canonicalPath) ? path : canonicalPath;
            Resource resource = new Resource(path, canonicalPath, currentUserSession, keyAttrs.get("templateType"), keyAttrs.get("template"), keyAttrs.get("context"));
            resource.getModuleParams().put(AGGREGATING_KEY, (Serializable)((Object)key));
            Map<String, Object> original = this.keyGenerator.prepareContextForContentGeneration(keyAttrs, resource, renderContext);
            try {
                content = RenderService.getInstance().render(resource, renderContext);
                if (logger.isDebugEnabled()) {
                    logger.debug("fragment generated for resource {}", (Object)resource);
                    if (SettingsBean.getInstance().isDevelopmentMode()) {
                        logger.debug(content);
                    }
                }
            }
            finally {
                this.keyGenerator.restoreContextAfterContentGeneration(keyAttrs, resource, renderContext, original);
            }
            return content;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public void setKeyGenerator(CacheKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public static boolean skipAggregation(ServletRequest request) {
        return BooleanUtils.isTrue((Boolean)((Boolean)request.getAttribute(SKIP_AGGREGATION)));
    }
}

