/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Render;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.SiteInfo;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Url;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLResolver {
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String DEFAULT_WORKSPACE = "live";
    private static final Pattern MACRO_URL_PATTERN = Pattern.compile("(.?)*.html##[a-zA-Z]*##$");
    private static final String VANITY_URL_NODE_PATH_SEGMENT = "/vanityUrlMapping/";
    private static final Pattern CROSS_SITES_URL_PATTERN = Pattern.compile("[a-z]{0,3}_?[A-Z]{0,2}/sites/.*");
    private static final Logger logger = LoggerFactory.getLogger(URLResolver.class);
    private static final String[] SERVLETS_ALLOWING_URL_MAPPING = new String[]{StringUtils.substringAfterLast((String)Render.getRenderServletPath(), (String)"/")};
    private static JahiaSitesService sitesService = ServicesRegistry.getInstance().getJahiaSitesService();
    private String urlPathInfo = null;
    private String servletPart = "";
    private String workspace;
    private Locale locale;
    private String path = "";
    private String siteKey;
    private String siteKeyByServerName;
    private boolean mappable = false;
    private String redirectUrl;
    private String vanityUrl;
    private Date versionDate;
    private String versionLabel;
    private static final String CACHE_KEY_SEPARATOR = "___";
    private SiteInfo siteInfo;
    private RenderContext renderContext;
    private Map<String, JCRNodeWrapper> resolvedNodes = new ConcurrentHashMap<String, JCRNodeWrapper>();
    private Ehcache nodePathCache;
    private Ehcache siteInfoCache;

    public void setRenderContext(RenderContext renderContext) {
        this.renderContext = renderContext;
    }

    protected URLResolver(String urlPathInfo, String serverName, HttpServletRequest request, Ehcache nodePathCache, Ehcache siteInfoCache) {
        this(urlPathInfo, serverName, null, request, nodePathCache, siteInfoCache);
    }

    protected URLResolver(String pathInfo, String serverName, String workspace, HttpServletRequest request, Ehcache nodePathCache, Ehcache siteInfoCache) {
        this.nodePathCache = nodePathCache;
        this.siteInfoCache = siteInfoCache;
        this.workspace = workspace;
        this.urlPathInfo = URLResolver.normalizeUrlPathInfo(pathInfo);
        if (!JahiaUserManagerService.isGuest(JCRSessionFactory.getInstance().getCurrentUser())) {
            Date date = this.getVersionDate(request);
            String versionLabel = this.getVersionLabel(request);
            this.setVersionDate(date);
            this.setVersionLabel(versionLabel);
        }
        if (this.urlPathInfo != null) {
            this.servletPart = StringUtils.substring((String)this.getUrlPathInfo(), (int)1, (int)StringUtils.indexOf((String)this.getUrlPathInfo(), (String)"/", (int)1));
            this.path = StringUtils.substring((String)this.getUrlPathInfo(), (int)(this.servletPart.length() + 2), (int)this.getUrlPathInfo().length());
        }
        if (!this.resolveUrlMapping(serverName, request)) {
            this.init();
            if (!Url.isLocalhost(serverName) && this.isMappable() && SettingsBean.getInstance().isPermanentMoveForVanityURL()) {
                try {
                    VanityUrl defaultVanityUrl;
                    JCRNodeWrapper targetNode;
                    if (this.siteKeyByServerName != null && this.siteKeyByServerName.equals((targetNode = this.getNode()).getResolveSite().getSiteKey()) && (defaultVanityUrl = this.getVanityUrlService().getVanityUrlForWorkspaceAndLocale(targetNode, this.workspace, this.locale, this.siteKey)) != null && defaultVanityUrl.isActive()) {
                        this.redirect(request, defaultVanityUrl);
                    }
                }
                catch (PathNotFoundException e) {
                    logger.debug("Path not found: {}", (Object)this.urlPathInfo);
                }
                catch (AccessDeniedException e) {
                    logger.debug("User has no access to the resource, so there will not be a redirection");
                }
                catch (RepositoryException e) {
                    logger.warn("Error when trying to check whether there is a vanity URL mapping", (Throwable)e);
                }
            }
        }
    }

    private void redirect(HttpServletRequest request, VanityUrl defaultVanityUrl) {
        if (request == null || StringUtils.isEmpty((String)request.getQueryString())) {
            this.setRedirectUrl(defaultVanityUrl.getUrl());
        } else {
            String queryString = "?";
            try {
                queryString = queryString + URLDecoder.decode(request.getQueryString(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                logger.error("Error decoding query string, will use undecoded query string instead", (Throwable)uee);
                queryString = queryString + request.getQueryString();
            }
            this.setRedirectUrl(defaultVanityUrl.getUrl() + queryString);
        }
    }

    private static String normalizeUrlPathInfo(String urlPathInfo) {
        if (urlPathInfo != null && urlPathInfo.length() > 1 && urlPathInfo.charAt(urlPathInfo.length() - 1) == '/') {
            urlPathInfo = urlPathInfo.substring(0, urlPathInfo.length() - 1);
            return urlPathInfo;
        }
        return urlPathInfo;
    }

    protected URLResolver(String url, RenderContext context, Ehcache nodePathCache, Ehcache siteInfoCache) {
        this.nodePathCache = nodePathCache;
        this.siteInfoCache = siteInfoCache;
        this.renderContext = context;
        String contextPath = context.getRequest().getContextPath();
        this.urlPathInfo = URLResolver.normalizeUrlPathInfo(StringUtils.substringAfter((String)url, (String)(!StringUtils.isEmpty((String)contextPath) ? contextPath + context.getServletPath() : context.getServletPath())));
        this.servletPart = StringUtils.substringAfterLast((String)context.getServletPath(), (String)"/");
        if (!StringUtils.isEmpty((String)this.urlPathInfo)) {
            this.path = this.getUrlPathInfo().substring(1);
            this.init();
        }
    }

    private void init() {
        this.workspace = this.verifyWorkspace(StringUtils.substringBefore((String)this.path, (String)"/"));
        this.path = StringUtils.substringAfter((String)this.path, (String)"/");
        this.locale = this.verifyLanguage(StringUtils.substringBefore((String)this.path, (String)"/"));
        this.path = "/" + (this.locale != null ? StringUtils.substringAfter((String)this.path, (String)"/") : this.path);
        String lastPart = StringUtils.substringAfterLast((String)this.path, (String)"/");
        int indexOfHTMLSuffix = lastPart.indexOf(".html");
        if (this.isServletAllowingUrlMapping() && indexOfHTMLSuffix > 0 && (lastPart.endsWith(".html") || MACRO_URL_PATTERN.matcher(lastPart).matches())) {
            this.mappable = true;
        }
    }

    private Date getVersionDate(HttpServletRequest req) {
        String msString = req.getParameter("v");
        if (msString == null) {
            return null;
        }
        try {
            long msLong = Long.parseLong(msString);
            if (logger.isDebugEnabled()) {
                logger.debug("Display version of date : " + SimpleDateFormat.getDateTimeInstance(1, 1).format(new Date(msLong)));
            }
            return new Date(msLong);
        }
        catch (NumberFormatException nfe) {
            logger.warn("Invalid version date found in URL {}", (Object)msString);
            return null;
        }
    }

    private String getVersionLabel(HttpServletRequest req) {
        return req.getParameter("l");
    }

    private boolean isServletAllowingUrlMapping() {
        boolean isServletAllowingUrlMapping = false;
        for (String servletAllowingUrlMapping : SERVLETS_ALLOWING_URL_MAPPING) {
            if (!servletAllowingUrlMapping.equals(this.servletPart)) continue;
            isServletAllowingUrlMapping = true;
            break;
        }
        return isServletAllowingUrlMapping;
    }

    protected boolean resolveUrlMapping(String serverName, HttpServletRequest request) {
        boolean mappingResolved = false;
        try {
            this.siteKeyByServerName = sitesService.getSitenameByServerName(serverName);
        }
        catch (JahiaException e) {
            logger.warn("Error finding site via servername: " + serverName, (Throwable)e);
        }
        if (this.getSiteKey() == null) {
            String siteKeyInPath = this.resolveSiteKeyFromPath(this.getPath());
            if (!StringUtils.isEmpty((String)siteKeyInPath)) {
                this.setSiteKey(siteKeyInPath);
            } else if (!Url.isLocalhost(serverName) && this.siteKeyByServerName != null) {
                this.setSiteKey(this.siteKeyByServerName);
            }
        }
        if (this.isServletAllowingUrlMapping() && !Url.isLocalhost(serverName)) {
            String tempPath = null;
            try {
                List<VanityUrl> vanityUrls;
                boolean doNotMatchesCrossSitesPattern;
                String tempWorkspace = this.verifyWorkspace(StringUtils.substringBefore((String)this.getPath(), (String)"/"));
                tempPath = StringUtils.substringAfter((String)this.getPath(), (String)"/");
                VanityUrl resolvedVanityUrl = null;
                logger.debug("Trying to resolve vanity url for tempPath = {}", (Object)tempPath);
                boolean bl = doNotMatchesCrossSitesPattern = !CROSS_SITES_URL_PATTERN.matcher(tempPath).matches();
                if (!StringUtils.isEmpty((String)this.getSiteKey()) && doNotMatchesCrossSitesPattern) {
                    vanityUrls = this.getVanityUrlService().findExistingVanityUrls("/" + tempPath, this.getSiteKey(), tempWorkspace);
                    for (VanityUrl vanityUrl : vanityUrls) {
                        if (!vanityUrl.isActive()) continue;
                        resolvedVanityUrl = vanityUrl;
                        break;
                    }
                } else if (doNotMatchesCrossSitesPattern) {
                    vanityUrls = this.getVanityUrlService().findExistingVanityUrls("/" + tempPath, "", tempWorkspace);
                    for (VanityUrl vanityUrl : vanityUrls) {
                        if (!vanityUrl.isActive() || !StringUtils.isEmpty((String)this.getSiteKey()) && !this.getSiteKey().equals(vanityUrl.getSite())) continue;
                        resolvedVanityUrl = vanityUrl;
                        break;
                    }
                }
                if (resolvedVanityUrl != null) {
                    VanityUrl defaultVanityUrl;
                    this.workspace = tempWorkspace;
                    this.locale = StringUtils.isEmpty((String)resolvedVanityUrl.getLanguage()) ? DEFAULT_LOCALE : LanguageCodeConverters.languageCodeToLocale(resolvedVanityUrl.getLanguage());
                    String nodePath = StringUtils.substringBefore((String)resolvedVanityUrl.getPath(), (String)VANITY_URL_NODE_PATH_SEGMENT);
                    this.path = nodePath + ".html";
                    this.setVanityUrl(resolvedVanityUrl.getUrl());
                    if (SettingsBean.getInstance().isPermanentMoveForVanityURL() && !resolvedVanityUrl.isDefaultMapping() && (defaultVanityUrl = this.getVanityUrlService().getVanityUrlForWorkspaceAndLocale(nodePath, this.workspace, this.locale, this.siteKey)) != null && defaultVanityUrl.isActive() && !resolvedVanityUrl.equals(defaultVanityUrl)) {
                        this.redirect(request, defaultVanityUrl);
                    }
                    mappingResolved = true;
                }
            }
            catch (RepositoryException e) {
                logger.warn("Error when trying to resolve URL mapping: " + tempPath, (Throwable)e);
            }
        }
        return mappingResolved;
    }

    public String getUrlPathInfo() {
        return this.urlPathInfo;
    }

    public String getServletPart() {
        return this.servletPart;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public Locale getLocale() {
        Locale uiLocale = null;
        if (this.renderContext != null && this.renderContext.isForceUILocaleForJCRSession()) {
            uiLocale = this.renderContext.getUILocale();
        }
        return uiLocale != null ? uiLocale : this.locale;
    }

    public String getPath() {
        return this.path;
    }

    public JCRNodeWrapper getNode() throws RepositoryException {
        return this.resolveNode(this.getWorkspace(), this.getLocale(), this.getPath());
    }

    public Resource getResource() throws RepositoryException {
        return this.resolveResource(this.getWorkspace(), this.getLocale(), this.getPath());
    }

    public Resource getResource(String path) throws RepositoryException {
        return this.resolveResource(this.getWorkspace(), this.getLocale(), path);
    }

    protected JCRNodeWrapper resolveNode(String workspace, Locale locale, final String path) throws RepositoryException {
        JCRSessionWrapper userSession;
        logger.debug("Resolving node for workspace '{}' locale '{}' and path '{}'", new Object[]{workspace, locale, path});
        final String cacheKey = this.getCacheKey(workspace, locale, path);
        if (this.resolvedNodes.containsKey(cacheKey)) {
            return this.resolvedNodes.get(cacheKey);
        }
        JCRNodeWrapper node = null;
        Element element = this.nodePathCache.get((Serializable)((Object)cacheKey));
        String nodePath = null;
        if (element != null) {
            nodePath = (String)element.getObjectValue();
        }
        if ((element = this.siteInfoCache.get((Serializable)((Object)cacheKey))) != null) {
            this.siteInfo = (SiteInfo)element.getObjectValue();
        }
        if (nodePath == null || this.siteInfo == null) {
            nodePath = JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, locale, new JCRCallback<String>(){

                @Override
                public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    String nodePath = JCRContentUtils.escapeNodePath(path.endsWith("/*") ? path.substring(0, path.lastIndexOf("/*")) : path);
                    String siteName = URLResolver.this.resolveSiteKeyFromPath(nodePath);
                    if (siteName != null && session.itemExists("/sites/" + siteName)) {
                        URLResolver.this.siteInfo = new SiteInfo((JCRSiteNode)session.getNode("/sites/" + siteName));
                        if (URLResolver.this.siteInfo.isMixLanguagesActive() && URLResolver.this.siteInfo.getDefaultLanguage() != null) {
                            session.setFallbackLocale(LanguageCodeConverters.getLocaleFromCode(URLResolver.this.siteInfo.getDefaultLanguage()));
                        }
                    }
                    logger.debug("{} has not been found in the cache, still looking for node {}", (Object)cacheKey, (Object)nodePath);
                    JCRNodeWrapper node = null;
                    while (true) {
                        try {
                            node = session.getNode(nodePath);
                        }
                        catch (PathNotFoundException ex) {
                            if (nodePath.lastIndexOf("/") < nodePath.lastIndexOf(".")) {
                                nodePath = nodePath.substring(0, nodePath.lastIndexOf("."));
                                continue;
                            }
                            throw new PathNotFoundException("'" + nodePath + "'not found");
                        }
                        break;
                    }
                    URLResolver.this.nodePathCache.put(new Element((Serializable)((Object)cacheKey), (Serializable)((Object)nodePath)));
                    JCRSiteNode resolveSite = node.getResolveSite();
                    if (resolveSite != null) {
                        URLResolver.this.siteInfo = new SiteInfo(resolveSite);
                        URLResolver.this.siteInfoCache.put(new Element((Serializable)((Object)cacheKey), (Serializable)URLResolver.this.siteInfo));
                    }
                    return nodePath;
                }
            });
        }
        if (this.siteInfo == null) {
            this.siteInfoCache.remove((Serializable)((Object)cacheKey));
            throw new RepositoryException("could not resolve site for " + path + " in workspace " + workspace + " in language " + locale);
        }
        if (this.siteInfo.isMixLanguagesActive() && this.siteInfo.getDefaultLanguage() != null) {
            JCRSessionFactory.getInstance().setFallbackLocale(LanguageCodeConverters.getLocaleFromCode(this.siteInfo.getDefaultLanguage()));
        }
        if ((userSession = JCRSessionFactory.getInstance().getCurrentUserSession(workspace, locale)).getVersionDate() == null && this.versionDate != null) {
            userSession.setVersionDate(this.versionDate);
        }
        if (userSession.getVersionLabel() == null && this.versionLabel != null) {
            userSession.setVersionLabel(this.versionLabel);
        }
        try {
            node = userSession.getNode(nodePath);
        }
        catch (PathNotFoundException e) {
            throw new AccessDeniedException(path);
        }
        this.resolvedNodes.put(cacheKey, node);
        return node;
    }

    private String getCacheKey(String workspace, Locale locale, String path) {
        StringBuilder builder = new StringBuilder(workspace != null ? workspace : "null");
        builder.append(CACHE_KEY_SEPARATOR);
        builder.append(locale != null ? locale.toString() : "null");
        builder.append(CACHE_KEY_SEPARATOR);
        builder.append(path);
        return builder.toString();
    }

    protected Resource resolveResource(final String workspace, final Locale locale, final String path) throws RepositoryException {
        logger.debug("Resolving resource for workspace '{}' locale '{}' and path '{}'", new Object[]{workspace, locale, path});
        if (locale == null) {
            throw new JahiaBadRequestException("Unknown locale");
        }
        final URLResolver urlResolver = this;
        return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, locale, new JCRCallback<Resource>(){

            @Override
            public Resource doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper node;
                String ext = null;
                String tpl = null;
                String nodePath = JCRContentUtils.escapeNodePath(path);
                while (true) {
                    int i;
                    if ((i = nodePath.lastIndexOf(46)) > nodePath.lastIndexOf(47)) {
                        if (ext == null) {
                            ext = nodePath.substring(i + 1);
                            if ("ajax".equals(ext)) {
                                ext = null;
                                if (URLResolver.this.renderContext != null) {
                                    URLResolver.this.renderContext.setAjaxRequest(true);
                                    HttpServletRequest req = URLResolver.this.renderContext.getRequest();
                                    if (req.getParameter("mainResource") != null && !req.getParameter("mainResource").equals(path)) {
                                        try {
                                            Resource resource = urlResolver.getResource(req.getParameter("mainResource"));
                                            URLResolver.this.renderContext.setAjaxResource(resource);
                                        }
                                        catch (PathNotFoundException resource) {}
                                    }
                                }
                            }
                        } else {
                            tpl = tpl == null ? nodePath.substring(i + 1) : nodePath.substring(i + 1) + "." + tpl;
                        }
                    } else {
                        throw new PathNotFoundException("not found");
                    }
                    nodePath = nodePath.substring(0, i);
                    try {
                        node = session.getNode(nodePath);
                    }
                    catch (PathNotFoundException req) {
                        continue;
                    }
                    break;
                }
                Element element = URLResolver.this.siteInfoCache.get((Serializable)((Object)URLResolver.this.getCacheKey(workspace, locale, path)));
                SiteInfo siteInfo = null;
                if (element != null) {
                    siteInfo = (SiteInfo)element.getObjectValue();
                }
                boolean mixLanguagesActive = false;
                String defaultLanguage = null;
                if (siteInfo == null) {
                    JCRSiteNode site = node.getResolveSite();
                    if (site != null) {
                        defaultLanguage = site.getDefaultLanguage();
                        mixLanguagesActive = site.isMixLanguagesActive();
                        URLResolver.this.siteInfoCache.put(new Element((Serializable)((Object)URLResolver.this.getCacheKey(workspace, locale, path)), (Serializable)new SiteInfo(site)));
                    }
                } else {
                    defaultLanguage = siteInfo.getDefaultLanguage();
                    mixLanguagesActive = siteInfo.isMixLanguagesActive();
                }
                JCRSessionWrapper userSession = defaultLanguage != null && mixLanguagesActive ? JCRSessionFactory.getInstance().getCurrentUserSession(workspace, locale, LanguageCodeConverters.languageCodeToLocale(defaultLanguage)) : JCRSessionFactory.getInstance().getCurrentUserSession(workspace, locale);
                if (userSession.getVersionDate() == null) {
                    userSession.setVersionDate(URLResolver.this.versionDate);
                }
                if (userSession.getVersionLabel() == null) {
                    userSession.setVersionLabel(URLResolver.this.versionLabel);
                }
                try {
                    node = userSession.getNode(nodePath);
                }
                catch (PathNotFoundException e) {
                    throw new AccessDeniedException(path);
                }
                Resource r = new Resource(node, ext, tpl, "page");
                logger.debug("Resolved resource: {}", (Object)r);
                return r;
            }
        });
    }

    private String resolveSiteKeyFromPath(String path) {
        String siteKey = StringUtils.substringBetween((String)path, (String)"/sites/", (String)"/");
        if (StringUtils.isNotEmpty((String)siteKey)) {
            return siteKey;
        }
        String pathEnding = StringUtils.substringAfter((String)path, (String)"/sites/");
        if (StringUtils.isEmpty((String)pathEnding)) {
            return null;
        }
        List<String> siteNames = sitesService.getSitesNames();
        String siteKeyCandidate = pathEnding;
        while (!siteNames.contains(siteKeyCandidate)) {
            if (!StringUtils.contains((String)siteKeyCandidate, (String)".")) {
                return null;
            }
            siteKeyCandidate = StringUtils.substringBeforeLast((String)siteKeyCandidate, (String)".");
        }
        return siteKeyCandidate;
    }

    public boolean isMappable() {
        return this.mappable;
    }

    public boolean isMapped() {
        boolean mapped = this.mappable;
        if (mapped) {
            try {
                Resource resource = this.getResource();
                if (!resource.getTemplate().equals("default")) {
                    return false;
                }
                JCRNodeWrapper node = resource.getNode();
                if (node != null && !node.isNodeType("jmix:vanityUrlMapped")) {
                    mapped = false;
                }
            }
            catch (RepositoryException e) {
                logger.debug("Cannot check if node has the jmix:vanityUrlMapped mixin", (Throwable)e);
            }
        }
        return mapped;
    }

    private VanityUrlService getVanityUrlService() {
        return (VanityUrlService)SpringContextSingleton.getBean(VanityUrlService.class.getName());
    }

    public String getSiteKey() {
        return this.siteKey;
    }

    public void setSiteKey(String siteKey) {
        this.siteKey = siteKey;
    }

    public String getSiteKeyByServerName() {
        return this.siteKeyByServerName;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public String getVanityUrl() {
        return this.vanityUrl;
    }

    public void setVanityUrl(String vanityUrl) {
        this.vanityUrl = vanityUrl;
    }

    protected Locale verifyLanguage(String lang) {
        if (StringUtils.isEmpty((String)lang)) {
            return DEFAULT_LOCALE;
        }
        if (!LanguageCodeConverters.LANGUAGE_PATTERN.matcher(lang).matches()) {
            return null;
        }
        return LanguageCodeConverters.languageCodeToLocale(lang);
    }

    protected String verifyWorkspace(String workspace) {
        if (StringUtils.isEmpty((String)workspace)) {
            if (workspace == null) {
                workspace = DEFAULT_WORKSPACE;
            }
        } else {
            if (!JCRContentUtils.isValidWorkspace(workspace) && this.workspace == null) {
                throw new JahiaBadRequestException("Unknown workspace '" + workspace + "'");
            }
            if (JCRContentUtils.isValidWorkspace(workspace) && this.workspace != null && !workspace.equals(this.workspace)) {
                throw new JahiaBadRequestException("Invalid workspace '" + workspace + "'");
            }
            if (!JCRContentUtils.isValidWorkspace(workspace) && this.workspace != null) {
                workspace = this.workspace;
                this.path = this.workspace + "/" + this.path;
            }
        }
        return workspace;
    }

    public void setVersionDate(Date versionDate) {
        this.versionDate = versionDate;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public Date getVersionDate() {
        return this.versionDate;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public SiteInfo getSiteInfo() {
        return this.siteInfo;
    }
}

