/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.RenderFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderInfo {
    private static final Logger logger = LoggerFactory.getLogger(RenderInfo.class);
    private static ThreadLocal<RenderInfo> threadLocal = new ThreadLocal();
    private static List<RenderInfo> all = new ArrayList<RenderInfo>();
    private static boolean enabled = false;
    private Resource resource;
    private long startTime = System.currentTimeMillis();
    private long endTime;
    private List<FilterEvent> filterEvents = new ArrayList<FilterEvent>();
    private RenderInfo parent;
    private List<RenderInfo> subResources = new ArrayList<RenderInfo>();

    public static void setEnabled(boolean enabled) {
        RenderInfo.enabled = enabled;
        logger.info(enabled ? "The rendering data collection is now enabled" : "The rendering data collection is now disabled");
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void pushResource(Resource resource) {
        if (enabled) {
            RenderInfo r = new RenderInfo(resource);
            if (threadLocal.get() == null) {
                all.add(r);
            } else {
                r.setParent(threadLocal.get());
                RenderInfo.threadLocal.get().subResources.add(r);
            }
            threadLocal.set(r);
        }
    }

    public static void popResource() {
        RenderInfo info = threadLocal.get();
        if (info != null) {
            info.endTime = System.currentTimeMillis();
            threadLocal.set(info.parent);
        }
    }

    public static void addFilterEvent(RenderFilter filter, int type) {
        RenderInfo info = threadLocal.get();
        if (info != null) {
            info.filterEvents.add(new FilterEvent(filter.getClass().getName(), System.currentTimeMillis(), type));
        }
    }

    public static String dump() {
        RenderInfo.setEnabled(false);
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            new ObjectMapper().writeValue((Writer)writer, all);
            all.clear();
        }
        catch (IOException e) {
            logger.warn("Error dumping rendering data into JSON. Cause: " + e.getMessage(), (Throwable)e);
        }
        return writer.getBuffer().toString();
    }

    private RenderInfo(Resource resource) {
        this.resource = resource;
    }

    private void setParent(RenderInfo parent) {
        this.parent = parent;
    }

    public String getResourcePath() {
        return this.resource.getPath();
    }

    public String getResourceTemplate() {
        return this.resource.getResolvedTemplate();
    }

    public String getContextConfiguration() {
        return this.resource.getContextConfiguration();
    }

    public Map<String, Serializable> getModuleParams() {
        return this.resource.getModuleParams();
    }

    public long getTime() {
        return this.endTime - this.startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public List<FilterEvent> getFilterEvents() {
        return this.filterEvents;
    }

    public List<RenderInfo> getSubResources() {
        return this.subResources;
    }

    public static class FilterEvent {
        public static final int TYPE_PREPARE = 0;
        public static final int TYPE_EXECUTE = 1;
        public static final int TYPE_GET_ERROR_CONTENT = 2;
        public static final int TYPE_FINALIZE = 3;
        private String filter;
        private long date;
        private int type;

        FilterEvent(String filter, long date, int type) {
            this.filter = filter;
            this.date = date;
            this.type = type;
        }

        public String getFilter() {
            return this.filter;
        }

        public long getDate() {
            return this.date;
        }

        public int getType() {
            return this.type;
        }
    }
}

