/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.pwdpolicy;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyRuleParam;

public class JahiaPasswordPolicyRule
implements Serializable {
    private static final long serialVersionUID = -3688773450875340830L;
    public static final char ACTION_INVALIDATE_PASSWORD = 'P';
    public static final char ACTION_WARN = 'W';
    public static final char EVALUATOR_GROOVY = 'G';
    public static final char EVALUATOR_JAVA = 'J';
    private String id;
    private String name;
    private boolean lastRule;
    private char action = (char)87;
    private char evaluator = (char)74;
    private boolean active = true;
    private boolean periodical;
    private String condition;
    private List<JahiaPasswordPolicyRuleParam> conditionParameters = new LinkedList<JahiaPasswordPolicyRuleParam>();
    private List<JahiaPasswordPolicyRuleParam> actionParameters = new LinkedList<JahiaPasswordPolicyRuleParam>();

    public JahiaPasswordPolicyRule() {
    }

    public JahiaPasswordPolicyRule(String id, String name, boolean active, boolean periodical, boolean lastRule, char evaluator, String condition, char action) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.periodical = periodical;
        this.lastRule = lastRule;
        this.evaluator = evaluator;
        this.condition = condition;
        this.action = action;
    }

    public JahiaPasswordPolicyRule(JahiaPasswordPolicyRule rule) {
        this(rule.id, rule.name, rule.active, rule.periodical, rule.lastRule, rule.evaluator, rule.condition, rule.action);
        this.actionParameters = rule.actionParameters == null ? null : (List)rule.actionParameters.stream().map(p -> new JahiaPasswordPolicyRuleParam((JahiaPasswordPolicyRuleParam)p)).collect(Collectors.toCollection(LinkedList::new));
        this.conditionParameters = rule.conditionParameters == null ? null : (List)rule.conditionParameters.stream().map(p -> new JahiaPasswordPolicyRuleParam((JahiaPasswordPolicyRuleParam)p)).collect(Collectors.toCollection(LinkedList::new));
    }

    public char getAction() {
        return this.action;
    }

    public List<JahiaPasswordPolicyRuleParam> getActionParameters() {
        return this.actionParameters;
    }

    public Map<String, String> getActionParametersValues() {
        if (this.actionParameters.size() == 0) {
            return Collections.emptyMap();
        }
        return this.actionParameters.stream().collect(Collectors.toMap(JahiaPasswordPolicyRuleParam::getName, JahiaPasswordPolicyRuleParam::getValue));
    }

    public String getCondition() {
        return this.condition;
    }

    public List<JahiaPasswordPolicyRuleParam> getConditionParameters() {
        return this.conditionParameters;
    }

    public Map<String, String> getConditionParametersValues() {
        if (this.conditionParameters.size() == 0) {
            return Collections.emptyMap();
        }
        return this.conditionParameters.stream().collect(Collectors.toMap(JahiaPasswordPolicyRuleParam::getName, JahiaPasswordPolicyRuleParam::getValue));
    }

    public char getEvaluator() {
        return this.evaluator;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isLastRule() {
        return this.lastRule;
    }

    public boolean isPeriodical() {
        return this.periodical;
    }

    public void setAction(char action) {
        this.action = action;
    }

    public void setActionParameters(List<JahiaPasswordPolicyRuleParam> actionParameters) {
        this.actionParameters = actionParameters;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setConditionParameters(List<JahiaPasswordPolicyRuleParam> conditionParameters) {
        this.conditionParameters = conditionParameters;
    }

    public void setEvaluator(char evaluator) {
        this.evaluator = evaluator;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLastRule(boolean lastRule) {
        this.lastRule = lastRule;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(List<JahiaPasswordPolicyRuleParam> parameters) {
        this.conditionParameters = parameters;
    }

    public void setPeriodical(boolean periodical) {
        this.periodical = periodical;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            JahiaPasswordPolicyRule castOther = (JahiaPasswordPolicyRule)obj;
            return new EqualsBuilder().append((Object)this.getId(), (Object)castOther.getId()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("active", this.active).append("periodical", this.periodical).append("lastRule", this.lastRule).append("evaluator", this.evaluator).append("action", this.action).append("condition", (Object)(this.condition.length() > 255 ? this.condition.substring(0, 255) : this.condition)).append("parameters", this.conditionParameters).toString();
    }
}

