/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public class BundleBucketInfo
implements Serializable {
    private static final long serialVersionUID = 9116182373302703262L;
    private String groupId;
    private String symbolicName;

    public static BundleBucketInfo fromKey(String key) {
        String symbolicName;
        String groupId;
        if (key == null) {
            throw new IllegalArgumentException("Illegal bundle bucket key: " + key);
        }
        if (key.indexOf(47) == -1) {
            groupId = null;
            symbolicName = key;
        } else {
            groupId = StringUtils.substringBefore((String)key, (String)"/");
            symbolicName = StringUtils.substringAfter((String)key, (String)"/");
        }
        return new BundleBucketInfo(groupId, symbolicName);
    }

    public BundleBucketInfo(String groupId, String symbolicName) {
        if (symbolicName == null || symbolicName.isEmpty()) {
            throw new IllegalArgumentException("Symbolic name is required for the bundle bucket");
        }
        this.groupId = groupId;
        this.symbolicName = symbolicName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getKey() {
        return this.groupId == null ? this.symbolicName : this.groupId + '/' + this.symbolicName;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj.getClass() == this.getClass() && ((BundleBucketInfo)obj).getKey().equals(this.getKey());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

