/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaSiteImportException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.rules.Service;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.importexport.NoCloseZipInputStream;
import org.jahia.services.importexport.validation.ConstraintsValidatorResult;
import org.jahia.services.importexport.validation.MissingModulesValidationResult;
import org.jahia.services.importexport.validation.MissingNodetypesValidationResult;
import org.jahia.services.importexport.validation.MissingPortletsValidationResult;
import org.jahia.services.importexport.validation.MissingTemplatesValidationResult;
import org.jahia.services.importexport.validation.ProviderAvailabilityValidatorResult;
import org.jahia.services.importexport.validation.ValidationNotificationHandler;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.services.importexport.validation.ValidationResults;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.sites.SiteCreationInfo;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Url;
import org.jahia.utils.i18n.Messages;
import org.jahia.utils.zip.DirectoryZipInputStream;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SiteImportJob
extends BackgroundJob {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    public static final String NODEPATH = "nodepath";
    public static final String FILE_PATH = "filePath";
    public static final String DELETE_FILE = "deleteFile";
    public static final String NO_VALIDATION_MARKER = "-novalidation.zip";

    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
        BaseSiteImporter siteImporter;
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        JahiaUser user = JCRSessionFactory.getInstance().getCurrentUser();
        if (jobDataMap.get((Object)NODEPATH) != null) {
            siteImporter = new NodeSiteImporter(jobDataMap.getString(NODEPATH), user);
        } else if (jobDataMap.get((Object)FILE_PATH) != null) {
            siteImporter = new FileSiteImporter(jobDataMap.getString(FILE_PATH), jobDataMap.getBoolean(DELETE_FILE), user);
        } else {
            return;
        }
        siteImporter.execute();
        ((BaseSiteImporter)siteImporter).onImportFinish();
    }

    private String resolveFileName(String path) {
        String fileName = StringUtils.substringAfterLast((String)path, (String)"/");
        if (StringUtils.isBlank((String)fileName)) {
            fileName = StringUtils.substringAfterLast((String)path, (String)File.separator);
        }
        return fileName;
    }

    private class NodeSiteImporter
    extends BaseSiteImporter {
        JCRNodeWrapper node;

        NodeSiteImporter(String nodePath, JahiaUser user) throws RepositoryException, URISyntaxException {
            super(nodePath, SiteImportJob.this.resolveFileName(nodePath), user);
            this.node = this.session.getNode(nodePath);
        }

        @Override
        void importSiteZip() throws RepositoryException, JahiaException, IOException {
            ImportExportBaseService.getInstance().importSiteZip(this.node);
        }

        @Override
        InputStream getInputStream() throws RepositoryException {
            return this.node.getNode("jcr:content").getProperty("jcr:data").getBinary().getStream();
        }

        @Override
        void onImportFinish() {
        }

        @Override
        boolean noValidation() {
            return false;
        }
    }

    private class FileSiteImporter
    extends BaseSiteImporter {
        File file;
        boolean deleteFile;

        FileSiteImporter(String filePath, boolean deleteFile, JahiaUser user) throws RepositoryException, URISyntaxException {
            super(filePath, SiteImportJob.this.resolveFileName(filePath), user);
            this.file = Paths.get(filePath, new String[0]).toFile();
            this.deleteFile = deleteFile;
            if (!this.file.exists()) {
                throw new RuntimeException("Unable to import file: (" + filePath + "). Because it doesn't exists");
            }
        }

        @Override
        void importSiteZip() throws RepositoryException, JahiaException, IOException {
            ImportExportBaseService.getInstance().importSiteZip(this.file, this.session);
        }

        @Override
        InputStream getInputStream() throws FileNotFoundException {
            return new FileInputStream(this.file);
        }

        @Override
        void onImportFinish() {
            if (this.deleteFile) {
                this.file.delete();
            }
        }

        @Override
        boolean noValidation() {
            return this.file.getName().contains(SiteImportJob.NO_VALIDATION_MARKER);
        }
    }

    private abstract class BaseSiteImporter {
        String uri;
        String name;
        JahiaUser user;
        JCRSessionWrapper session;

        public BaseSiteImporter(String uri, String name, JahiaUser user) throws RepositoryException {
            this.uri = uri;
            this.name = name;
            this.user = user;
            this.session = JCRSessionFactory.getInstance().getCurrentUserSession();
        }

        public void execute() throws RepositoryException, JahiaSiteImportException {
            StringTokenizer st = new StringTokenizer(this.name, "_");
            String type = st.nextToken();
            if (type.equals("siteImport")) {
                try {
                    logger.info("Import site " + this.uri);
                    if (!this.user.isRoot()) {
                        return;
                    }
                    this.importSiteZip();
                }
                catch (Exception e) {
                    logger.error("Error during import of file " + this.uri, (Throwable)e);
                    ServicesRegistry.getInstance().getCacheService().flushAllCaches();
                }
            } else if (this.name.endsWith(".zip")) {
                try {
                    this.processFileImport(this.prepareFileImports());
                }
                catch (IOException | ServletException | JahiaException e) {
                    logger.error(e.getMessage(), e);
                }
                catch (JahiaSiteImportException e) {
                    logger.error("Site import failure, see logs for details");
                    throw e;
                }
            } else if (this.name.endsWith(".xml")) {
                try {
                    this.session.importXML("/", this.getInputStream(), 0, 0);
                    this.session.save();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Map<Object, Object>> prepareFileImports() throws IOException, RepositoryException {
            ZipEntry z;
            Properties exportProps = new Properties();
            ZipInputStream zis = new ZipInputStream(this.getInputStream());
            HashMap<File, String> imports = new HashMap<File, String>();
            ArrayList<File> importList = new ArrayList<File>();
            while ((z = zis.getNextEntry()) != null) {
                File i = File.createTempFile("import", ".zip");
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(i));
                try {
                    IOUtils.copy((InputStream)zis, (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)os);
                }
                String n = z.getName();
                if (n.equals("export.properties")) {
                    Object is = null;
                    try {
                        is = new BufferedInputStream(new FileInputStream(i), 1024);
                        exportProps.load((InputStream)is);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        FileUtils.deleteQuietly((File)i);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    FileUtils.deleteQuietly((File)i);
                    continue;
                }
                if (n.equals("classes.jar")) {
                    FileUtils.deleteQuietly((File)i);
                    continue;
                }
                if (n.equals("site.properties") || n.startsWith("export_") && n.endsWith(".xml")) {
                    FileUtils.deleteQuietly((File)i);
                    for (File file : imports.keySet()) {
                        FileUtils.deleteQuietly((File)file);
                    }
                    imports.clear();
                    importList.clear();
                    File tempFile = File.createTempFile("import", ".zip");
                    InputStream is = this.getInputStream();
                    BufferedOutputStream tos = new BufferedOutputStream(new FileOutputStream(tempFile));
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)tos);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                        IOUtils.closeQuietly((OutputStream)tos);
                    }
                    imports.put(tempFile, this.name);
                    importList.add(tempFile);
                    break;
                }
                imports.put(i, n);
                importList.add(i);
            }
            ArrayList<Map<Object, Object>> importsInfos = new ArrayList<Map<Object, Object>>();
            Map<Object, Object> users = null;
            Map<Object, Object> serverPermissions = null;
            for (File i : importList) {
                String fileName = (String)imports.get(i);
                Map<Object, Object> value = this.prepareSiteImport(i, (String)imports.get(i));
                if (value == null) continue;
                if ("users.xml".equals(fileName) || "users.zip".equals(fileName)) {
                    users = value;
                    continue;
                }
                if ("serverPermissions.xml".equals(fileName)) {
                    serverPermissions = value;
                    continue;
                }
                importsInfos.add(value);
            }
            if (serverPermissions != null) {
                importsInfos.add(0, serverPermissions);
            }
            if (users != null) {
                importsInfos.add(0, users);
            }
            return importsInfos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Object, Object> prepareSiteImport(File i, String filename) throws IOException {
            HashMap<Object, Object> importInfos = new HashMap<Object, Object>();
            importInfos.put("importFile", i);
            importInfos.put("importFileName", filename);
            importInfos.put("selected", Boolean.TRUE);
            if (filename.endsWith(".xml")) {
                importInfos.put("type", "xml");
            } else {
                ZipInputStream zis2 = new ZipInputStream(new BufferedInputStream(new FileInputStream(i)));
                boolean isSite = false;
                boolean isLegacySite = false;
                try {
                    ZipEntry z;
                    while ((z = zis2.getNextEntry()) != null) {
                        if ("site.properties".equals(z.getName())) {
                            Properties p = new Properties();
                            p.load(zis2);
                            zis2.closeEntry();
                            importInfos.putAll(p);
                            importInfos.put("templates", importInfos.containsKey("templatePackageName") ? importInfos.get("templatePackageName") : "");
                            importInfos.put("oldsitekey", importInfos.get("sitekey"));
                            isSite = true;
                            continue;
                        }
                        if (!z.getName().startsWith("export_")) continue;
                        isLegacySite = true;
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)zis2);
                }
                importInfos.put("isSite", isSite);
                if (isSite || isLegacySite) {
                    importInfos.put("type", "site");
                    if (!importInfos.containsKey("sitekey")) {
                        importInfos.put("sitekey", "");
                        importInfos.put("siteservername", "");
                        importInfos.put("sitetitle", "");
                        importInfos.put("description", "");
                        importInfos.put("mixLanguage", "false");
                        importInfos.put("templates", "");
                        importInfos.put("siteKeyExists", Boolean.TRUE);
                        importInfos.put("siteServerNameExists", Boolean.TRUE);
                    } else {
                        try {
                            JahiaSitesService sitesService = ServicesRegistry.getInstance().getJahiaSitesService();
                            importInfos.put("siteKeyExists", sitesService.getSiteByKey((String)importInfos.get("sitekey")) != null || "".equals(importInfos.get("sitekey")));
                            importInfos.put("siteServerNameExists", sitesService.getSite((String)importInfos.get("siteservername")) != null || "".equals(importInfos.get("siteservername")));
                        }
                        catch (JahiaException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    importInfos.put("type", "files");
                }
            }
            return importInfos;
        }

        private void processFileImport(List<Map<Object, Object>> importsInfos) throws IOException, RepositoryException, ServletException, JahiaException, JahiaSiteImportException {
            File file;
            this.handleValidation(importsInfos);
            for (Map<Object, Object> infos : importsInfos) {
                file = (File)infos.get("importFile");
                if (!infos.get("importFileName").equals("users.xml")) continue;
                ImportExportBaseService.getInstance().importUsers(file);
                break;
            }
            for (Map<Object, Object> infos : importsInfos) {
                file = (File)infos.get("importFile");
                if (file != null && infos.get("type").equals("files")) {
                    try {
                        ImportExportBaseService.getInstance().importSiteZip((Resource)new FileSystemResource(file), null, infos);
                    }
                    catch (RepositoryException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (infos.get("type").equals("xml") && (infos.get("importFileName").equals("serverPermissions.xml") || infos.get("importFileName").equals("users.xml")) || !infos.get("type").equals("site")) continue;
                String tpl = (String)infos.get("templates");
                if ("".equals(tpl)) {
                    tpl = null;
                }
                try {
                    SiteCreationInfo siteCreationInfo = SiteCreationInfo.builder().siteKey((String)infos.get("sitekey")).serverName((String)infos.get("siteservername")).serverNameAliases((String)infos.get("siteservernamealiases")).title((String)infos.get("sitetitle")).description("").templateSet(tpl).modulesToDeploy(null).locale(infos.containsKey("defaultLanguage") ? (String)infos.get("defaultLanguage") : SettingsBean.getInstance().getDefaultLanguageCode()).siteAdmin(this.user).firstImport("fileImport").fileImport((Resource)(file == null ? null : new FileSystemResource(file))).fileImportName((String)infos.get("importFileName")).originatingJahiaRelease((String)infos.get("originatingJahiaRelease")).build();
                    ServicesRegistry.getInstance().getJahiaSitesService().addSite(siteCreationInfo);
                }
                catch (Exception e) {
                    logger.error("Cannot create site " + infos.get("sitetitle"), (Throwable)e);
                }
            }
        }

        private void handleValidation(List<Map<Object, Object>> importsInfos) throws IOException, JahiaSiteImportException {
            if (!this.noValidation()) {
                String message;
                Map<Object, Object> siteInfo = this.getSiteInfo(importsInfos);
                if (siteInfo.isEmpty()) {
                    this.notifyUserOfError(siteInfo, "No site found in the import file");
                }
                if ((message = this.validateSite(siteInfo)) != null) {
                    this.notifyUserOfError(siteInfo, message);
                }
                List<String> neededModules = this.neededModules(siteInfo);
                ValidationResults results = this.validateImport(importsInfos, neededModules, Boolean.valueOf((String)siteInfo.get("islegacyimport")));
                StringBuilder builder = new StringBuilder();
                Locale locale = SettingsBean.getInstance().getDefaultLocale();
                ArrayList<String> memo = new ArrayList<String>();
                for (ValidationResult result : results.getResults()) {
                    String validationType = result.getClass().getName();
                    if (result.isSuccessful() || memo.contains(validationType)) continue;
                    memo.add(validationType);
                    if (result instanceof MissingModulesValidationResult) {
                        memo.add(MissingModulesValidationResult.class.getName());
                        this.importErrorMessageLineStepper(builder);
                        MissingModulesValidationResult missingModule = (MissingModulesValidationResult)result;
                        if (missingModule.isTargetTemplateSetPresent()) {
                            builder.append(Messages.getInternalWithArguments("failure.import.missingTemplateSet", locale, missingModule.getTargetTemplateSet()));
                        }
                        if (missingModule.getMissingModules().isEmpty()) continue;
                        builder.append(Messages.getInternalWithArguments("failure.import.missingModules", locale, missingModule.getMissingModules().size())).append(missingModule.getMissingModules());
                        continue;
                    }
                    if (result instanceof MissingNodetypesValidationResult) {
                        this.importErrorMessageLineStepper(builder);
                        builder.append(Messages.getInternalWithArguments("failure.import.missingNodetypes", locale, ((MissingNodetypesValidationResult)result).getMissingNodetypes(), ((MissingNodetypesValidationResult)result).getMissingMixins()));
                        continue;
                    }
                    if (result instanceof MissingTemplatesValidationResult) {
                        this.importErrorMessageLineStepper(builder);
                        MissingTemplatesValidationResult missingTemplates = (MissingTemplatesValidationResult)result;
                        builder.append(Messages.getInternalWithArguments("failure.import.missingTemplates", locale, missingTemplates.getMissingTemplates().size())).append(missingTemplates.getMissingTemplates().keySet());
                        continue;
                    }
                    if (result instanceof MissingPortletsValidationResult) {
                        this.importErrorMessageLineStepper(builder);
                        MissingPortletsValidationResult missingPortlets = (MissingPortletsValidationResult)result;
                        builder.append(Messages.getInternalWithArguments("failure.import.missingPortlets", locale, missingPortlets.getMissingPortlets().size())).append(missingPortlets.getMissingPortlets());
                        continue;
                    }
                    if (result instanceof ProviderAvailabilityValidatorResult) {
                        this.importErrorMessageLineStepper(builder);
                        ProviderAvailabilityValidatorResult providerAvailabilityValidatorResult = (ProviderAvailabilityValidatorResult)result;
                        builder.append(Messages.getInternalWithArguments("failure.import.unavailableProviders", locale, providerAvailabilityValidatorResult.getUnavailableProviders().size())).append(providerAvailabilityValidatorResult.getUnavailableProviders());
                        continue;
                    }
                    if (!(result instanceof ConstraintsValidatorResult)) continue;
                    ConstraintsValidatorResult constraintsValidatorResult = (ConstraintsValidatorResult)result;
                    this.importErrorMissingPropertiesAppender(builder, constraintsValidatorResult.getMissingMandatoryProperties(), locale);
                    this.importErrorMissingPropertiesAppender(builder, constraintsValidatorResult.getMissingMandatoryI18NProperties(), locale);
                    if (constraintsValidatorResult.getOtherConstraintViolations().size() > 0) {
                        this.importErrorMessageLineStepper(builder);
                        builder.append(Messages.getInternalWithArguments("failure.import.constraintViolation", locale, constraintsValidatorResult.getOtherConstraintViolations().size())).append(constraintsValidatorResult.getOtherConstraintViolations().keySet());
                    }
                    this.importErrorMessageLineStepper(builder);
                }
                if (builder.length() != 0) {
                    this.notifyUserOfError(siteInfo, builder.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ValidationResults validateImport(List<Map<Object, Object>> importInfos, List<String> neededModules, Boolean isLegacyImport) throws IOException {
            ValidationResults results = new ValidationResults();
            for (Map<Object, Object> infos : importInfos) {
                File i = (File)infos.get("importFile");
                ZipInputStream zis2 = i.isDirectory() ? new DirectoryZipInputStream(i) : new NoCloseZipInputStream(new BufferedInputStream(new FileInputStream(i)));
                try {
                    ZipEntry z;
                    while ((z = zis2.getNextEntry()) != null) {
                        String name = z.getName().replace('\\', '/');
                        if (isLegacyImport.booleanValue() || !name.contains("repository.xml") || name.contains("/")) continue;
                        ValidationResults validationResults = ImportExportBaseService.getInstance().validateImportFile(JCRSessionFactory.getInstance().getCurrentUserSession(), zis2, "application/xml", neededModules);
                        for (ValidationResult r : validationResults.getResults()) {
                            if (r.isSuccessful()) continue;
                            results.addResult(r);
                        }
                    }
                    zis2.closeEntry();
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (zis2 instanceof NoCloseZipInputStream) {
                        ((NoCloseZipInputStream)zis2).reallyClose();
                        continue;
                    }
                    zis2.close();
                }
            }
            return results;
        }

        private String validateSite(Map<Object, Object> siteInfo) {
            Locale locale = SettingsBean.getInstance().getDefaultLocale();
            String siteTitle = (String)siteInfo.get("sitetitle");
            String siteKey = (String)siteInfo.get("sitekey");
            String serverName = (String)siteInfo.get("siteservername");
            String serverNameAliases = (String)siteInfo.get("siteservernamealiases");
            if (StringUtils.isEmpty((String)siteTitle) || StringUtils.isEmpty((String)siteKey) || StringUtils.isEmpty((String)serverName)) {
                return Messages.get("resources.JahiaServerSettings", "serverSettings.manageWebProjects.warningMsg.completeRequestInfo", locale);
            }
            try {
                JahiaSitesService sitesService = JahiaSitesService.getInstance();
                boolean valid = sitesService.isSiteKeyValid(siteKey);
                if (!valid) {
                    return Messages.get("resources.JahiaServerSettings", "serverSettings.manageWebProjects.warningMsg.onlyLettersDigitsUnderscore", locale);
                }
                if (sitesService.getSiteByKey(siteKey) != null) {
                    return Messages.get("resources.JahiaServerSettings", "serverSettings.manageWebProjects.siteKeyExists", locale);
                }
                Boolean isLegacy = Boolean.valueOf((String)siteInfo.get("islegacyimport"));
                if (isLegacy.booleanValue() && (StringUtils.startsWithIgnoreCase((String)serverName, (String)"http://") || StringUtils.startsWithIgnoreCase((String)serverName, (String)"https://"))) {
                    serverName = StringUtils.substringAfter((String)serverName, (String)"://");
                }
                String serverNameValidation = this.validateServerName(serverName, locale);
                if (StringUtils.isNotEmpty((String)serverNameAliases)) {
                    for (String serverNameAlias : StringUtils.split((String)serverNameAliases, (String)", ")) {
                        serverNameValidation = this.validateServerName(serverNameAlias, locale);
                        if (serverNameValidation == null) continue;
                        return serverNameValidation;
                    }
                }
                return serverNameValidation;
            }
            catch (JahiaException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        private String validateServerName(String serverNameToValidate, Locale locale) throws JahiaException {
            JahiaSite existingSite;
            JahiaSitesService sitesService = JahiaSitesService.getInstance();
            if (!sitesService.isServerNameValid(serverNameToValidate)) {
                return Messages.get("resources.JahiaServerSettings", "serverSettings.manageWebProjects.warningMsg.invalidServerName", locale);
            }
            if (!Url.isLocalhost(serverNameToValidate) && (existingSite = sitesService.getSiteByServerName(serverNameToValidate)) != null) {
                return Messages.get("resources.JahiaServerSettings", "serverSettings.manageWebProjects.warningMsg.chooseAnotherServerName", locale);
            }
            return null;
        }

        private List<String> neededModules(Map<Object, Object> siteInfo) {
            ArrayList<String> neededModules = new ArrayList<String>();
            String template = "";
            template = (String)siteInfo.get("templates");
            for (Map.Entry<Object, Object> entry : siteInfo.entrySet()) {
                if (!entry.getKey().toString().contains("installedModules")) continue;
                neededModules.add((String)entry.getValue());
            }
            neededModules.remove(template);
            neededModules.add(0, template);
            return neededModules;
        }

        private Map<Object, Object> getSiteInfo(List<Map<Object, Object>> importsInfos) {
            for (Map<Object, Object> ii : importsInfos) {
                if (!ii.get("type").equals("site")) continue;
                return ii;
            }
            return Collections.emptyMap();
        }

        private void importErrorMessageLineStepper(StringBuilder errorMessage) {
            errorMessage.append(errorMessage.length() == 0 ? "\n" : "\n\n");
        }

        private void importErrorMissingPropertiesAppender(StringBuilder errorMessage, Map<String, Set<String>> missingProperties, Locale uiLocale) {
            for (Map.Entry<String, Set<String>> missingPropertiesEntry : missingProperties.entrySet()) {
                for (String missingProperty : missingPropertiesEntry.getValue()) {
                    this.importErrorMessageLineStepper(errorMessage);
                    errorMessage.append(Messages.getInternalWithArguments("failure.import.missingProperty", uiLocale, missingProperty, missingPropertiesEntry.getKey()));
                }
            }
        }

        private void notifyUserOfError(Map<Object, Object> siteInfo, String message) throws JahiaSiteImportException {
            ValidationNotificationHandler.notifyAdministratorWhenValidationFailed(siteInfo, message);
            throw new JahiaSiteImportException(message);
        }

        abstract void importSiteZip() throws RepositoryException, JahiaException, IOException;

        abstract InputStream getInputStream() throws RepositoryException, FileNotFoundException;

        abstract void onImportFinish();

        abstract boolean noValidation();
    }
}

