/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.Writer;
import java.util.Stack;
import org.jahia.services.importexport.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DataWriter
extends XMLWriter {
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private Object state = SEEN_NOTHING;
    private Stack stateStack = new Stack();
    private int indentStep = 4;
    private int depth = 0;

    public DataWriter() {
    }

    public DataWriter(XMLReader xmlreader) {
        super(xmlreader);
    }

    public DataWriter(Writer writer) {
        super(writer);
    }

    public DataWriter(XMLReader xmlreader, Writer writer) {
        super(xmlreader, writer);
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public void setIndentStep(int indentStep) {
        this.indentStep = indentStep;
    }

    @Override
    public void reset() {
        this.depth = 0;
        this.state = SEEN_NOTHING;
        this.stateStack = new Stack();
        super.reset();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            super.characters("\n".toCharArray(), 0, 1);
        }
        this.doIndent();
        super.startElement(uri, localName, qName, atts);
        ++this.depth;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            super.characters("\n".toCharArray(), 0, 1);
            this.doIndent();
        }
        super.endElement(uri, localName, qName);
        this.state = this.stateStack.pop();
    }

    @Override
    public void emptyElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.state = SEEN_ELEMENT;
        if (this.depth > 0) {
            super.characters("\n".toCharArray(), 0, 1);
        }
        this.doIndent();
        super.emptyElement(uri, localName, qName, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.state = SEEN_DATA;
        super.characters(ch, start, length);
    }

    private void doIndent() throws SAXException {
        if (this.indentStep > 0 && this.depth > 0) {
            int n = this.indentStep * this.depth;
            char[] ch = new char[n];
            for (int i = 0; i < n; ++i) {
                ch[i] = 32;
            }
            super.characters(ch, 0, n);
        }
    }
}

