/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.image;

import java.util.ArrayList;
import org.im4java.core.IMOperation;
import org.im4java.core.IdentifyCmd;
import org.im4java.core.Operation;
import org.im4java.process.ArrayListOutputConsumer;
import org.im4java.process.OutputConsumer;
import org.jahia.services.image.ImageMagickImage;
import org.jahia.services.image.ImageMagickImageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMagickImage6Service
extends ImageMagickImageService {
    private static final Logger logger = LoggerFactory.getLogger(ImageMagickImage6Service.class);
    private static ImageMagickImage6Service instance = new ImageMagickImage6Service();

    public static ImageMagickImage6Service getInstance() {
        return instance;
    }

    @Override
    protected void readDimensions(ImageMagickImage img) {
        long timer = System.currentTimeMillis();
        try {
            IMOperation op = new IMOperation();
            op.format("%w\n%h");
            op.addImage(new String[]{img.getFile().getPath()});
            IdentifyCmd identify = new IdentifyCmd();
            ArrayListOutputConsumer output = new ArrayListOutputConsumer();
            identify.setOutputConsumer((OutputConsumer)output);
            identify.run((Operation)op, new Object[0]);
            ArrayList cmdOutput = output.getOutput();
            img.setWidth(Integer.parseInt((String)cmdOutput.get(0)));
            img.setHeight(Integer.parseInt((String)cmdOutput.get(1)));
        }
        catch (Exception e) {
            logger.error("Error retrieving image dimensions for " + img.getPath() + ": " + e.getLocalizedMessage());
            if (logger.isDebugEnabled()) {
                logger.error("Error retrieving image dimensions for " + img.getPath(), (Throwable)e);
            }
            img.setWidth(-1);
            img.setHeight(-1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Dimensions read for image {} in {} ms: {} x {}", new Object[]{img.getFile().getPath(), System.currentTimeMillis() - timer, img.getWidth(), img.getHeight()});
        }
    }
}

