/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.templates.ComponentRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTypesChoiceListInitializerImpl
implements ChoiceListInitializer {
    private static final LinkedList<String> DEF_INCLUDES = new LinkedList<String>(Arrays.asList("jmix:editorialContent"));
    private static final Logger logger = LoggerFactory.getLogger(ComponentTypesChoiceListInitializerImpl.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        List<String> includes = DEF_INCLUDES;
        List<String> excludes = null;
        boolean restrictedToDependencies = true;
        if (StringUtils.isNotEmpty((String)param)) {
            if (StringUtils.startsWith((String)param, (String)"notRestrictedToDependencies;")) {
                restrictedToDependencies = false;
                param = StringUtils.substringAfter((String)param, (String)"notRestrictedToDependencies;");
            }
            includes = this.getNodeTypes(StringUtils.substringBefore((String)param, (String)";"));
            excludes = this.getNodeTypes(StringUtils.substringAfter((String)param, (String)";"));
        }
        LinkedList<ChoiceListValue> choiceList = new LinkedList<ChoiceListValue>();
        JCRNodeWrapper contextNode = (JCRNodeWrapper)context.get("contextNode");
        if (contextNode == null) {
            contextNode = (JCRNodeWrapper)context.get("contextParent");
        }
        try {
            for (Map.Entry<String, String> comp : ComponentRegistry.getComponentTypes(contextNode, includes, excludes, locale, restrictedToDependencies).entrySet()) {
                choiceList.add(new ChoiceListValue(comp.getValue(), comp.getKey()));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return choiceList;
    }

    private List<String> getNodeTypes(String typesString) {
        LinkedList<String> types = null;
        if (StringUtils.isNotEmpty((String)typesString)) {
            types = new LinkedList<String>();
            for (String value : StringUtils.split((String)typesString, (String)", ")) {
                if (!NodeTypeRegistry.getInstance().hasNodeType(value)) continue;
                types.add(value);
            }
        }
        return types;
    }
}

