/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.interceptor.BaseInterceptor;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.tags.TaggingService;

public class TagInterceptor
extends BaseInterceptor {
    TaggingService taggingService;

    @Override
    public Value beforeSetValue(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition, Value originalValue) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        String content = originalValue.getString();
        if (StringUtils.isEmpty((String)content)) {
            return originalValue;
        }
        return node.getSession().getValueFactory().createValue(this.taggingService.getTagHandler().execute(content));
    }

    @Override
    public Value[] beforeSetValues(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition, Value[] originalValues) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] res = new Value[originalValues.length];
        for (int i = 0; i < originalValues.length; ++i) {
            Value originalValue = originalValues[i];
            res[i] = this.beforeSetValue(node, name, definition, originalValue);
        }
        return res;
    }

    public TaggingService getTaggingService() {
        return this.taggingService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }
}

