/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.impl.jackrabbit;

import org.jahia.services.content.impl.jackrabbit.RetryStrategyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryOnExceptionStrategy {
    private static final Logger log = LoggerFactory.getLogger(RetryOnExceptionStrategy.class);
    public static final long DEFAULT_WAIT_TIME_IN_MILLIS = 500L;
    public static final int DEFAULT_MAX_RETIRES = 3;
    private int retries;
    private long timeToWait;
    private int triesLeft;

    public RetryOnExceptionStrategy() {
        this(3, 500L);
    }

    public RetryOnExceptionStrategy(int maxRetries, long intervalDelay) {
        this.retries = maxRetries;
        this.triesLeft = maxRetries;
        this.timeToWait = intervalDelay;
    }

    public long getTimeToWait() {
        return this.timeToWait;
    }

    public int getTriesLeft() {
        return this.triesLeft;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setTimeToWait(long timeToWait) {
        this.timeToWait = timeToWait;
    }

    public void setTriesLeft(int triesLeft) {
        this.triesLeft = triesLeft;
    }

    public boolean canRetry() {
        return this.triesLeft > 0;
    }

    private void waitUntilNextRetry() {
        try {
            log.info("Going to wait {}", (Object)this.timeToWait);
            Thread.sleep(this.timeToWait);
        }
        catch (InterruptedException iex) {
            log.trace(iex.getMessage(), (Throwable)iex);
            Thread.currentThread().interrupt();
        }
    }

    public void onErrorOccured() throws RetryStrategyException {
        --this.triesLeft;
        if (!this.canRetry()) {
            throw new RetryStrategyException("Failed: " + this.retries + " attempts reached at interval " + this.timeToWait + " ms.");
        }
        this.waitUntilNextRetry();
    }
}

