/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRReferenceNode
extends JCRNodeDecorator {
    private static transient Logger logger = LoggerFactory.getLogger(JCRReferenceNode.class);

    public JCRReferenceNode(JCRNodeWrapper node) {
        super(node);
    }

    public Node getNode() throws RepositoryException {
        if (this.hasProperty("j:node")) {
            return this.getProperty("j:node").getNode();
        }
        return null;
    }

    public void setNode(JCRNodeWrapper node) throws RepositoryException {
        this.setProperty("j:node", node);
    }

    @Override
    public String getDisplayableName() {
        String name = super.getDisplayableName();
        try {
            if (this.getName().equals(name) && this.getNode() != null && !this.getIdentifier().equals(this.getNode().getIdentifier())) {
                name = ((JCRNodeWrapper)this.getNode()).getDisplayableName();
            }
        }
        catch (RepositoryException e) {
            logger.warn("JCRReferenceNode : error while trying to display reference " + this.getPath());
        }
        return name;
    }

    public Node getContextualizedNode() throws RepositoryException {
        if (this.hasProperty("j:node")) {
            try {
                return this.getProperty("j:node").getContextualizedNode();
            }
            catch (ItemNotFoundException e) {
                return null;
            }
        }
        return null;
    }
}

