/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;

public class GroupNodeMembers
extends AbstractList<JCRNodeWrapper> {
    private List<JCRNodeWrapper> cache = new ArrayList<JCRNodeWrapper>();
    private GroupNodeMembersIterator cacheIterator;

    public GroupNodeMembers(JCRGroupNode group) throws RepositoryException {
        this.cacheIterator = new GroupNodeMembersIterator(group.getNode("j:members"));
    }

    @Override
    public JCRNodeWrapper get(int index) {
        while (this.cache.size() <= index && this.cacheIterator.hasNext()) {
            this.cache.add(this.cacheIterator.next());
        }
        return this.cache.get(index);
    }

    @Override
    public Iterator<JCRNodeWrapper> iterator() {
        return new CachedGroupNodeMembersIterator(0);
    }

    @Override
    public ListIterator<JCRNodeWrapper> listIterator() {
        return new CachedGroupNodeMembersIterator(0);
    }

    @Override
    public ListIterator<JCRNodeWrapper> listIterator(int index) {
        return new CachedGroupNodeMembersIterator(index);
    }

    @Override
    public int size() {
        while (this.cacheIterator.hasNext()) {
            this.cache.add(this.cacheIterator.next());
        }
        return this.cache.size();
    }

    class GroupNodeMembersIterator
    implements Iterator<JCRNodeWrapper> {
        Stack<JCRNodeIteratorWrapper> its = new Stack();
        JCRNodeWrapper next = null;

        GroupNodeMembersIterator(JCRNodeWrapper membersNode) throws RepositoryException {
            this.its.push(membersNode.getNodes());
        }

        @Override
        public boolean hasNext() {
            return this.fetchNext() != null;
        }

        @Override
        public JCRNodeWrapper next() {
            JCRNodeWrapper r = this.fetchNext();
            if (r == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            return r;
        }

        private JCRNodeWrapper fetchNext() {
            if (this.next != null) {
                return this.next;
            }
            try {
                do {
                    if (this.its.isEmpty()) {
                        return null;
                    }
                    if (this.its.peek().hasNext()) {
                        this.next = this.getNextMemberNodeOrDrillDown();
                        continue;
                    }
                    if (this.its.isEmpty()) continue;
                    this.its.pop();
                } while (this.next == null);
                return this.next;
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }

        private JCRNodeWrapper getNextMemberNodeOrDrillDown() throws RepositoryException {
            JCRNodeWrapper node = (JCRNodeWrapper)this.its.peek().next();
            JCRNodeWrapper memberNode = null;
            if (node.isNodeType("jnt:members")) {
                this.its.push(node.getNodes());
            } else if (node.isNodeType("jnt:member")) {
                try {
                    memberNode = node.getProperty("j:member").getValue().getNode();
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
            }
            return memberNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class CachedGroupNodeMembersIterator
    implements ListIterator<JCRNodeWrapper> {
        int cursor = 0;

        CachedGroupNodeMembersIterator(int cursor) {
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            try {
                GroupNodeMembers.this.get(this.cursor);
                return true;
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
        }

        @Override
        public JCRNodeWrapper next() {
            try {
                int i = this.cursor;
                JCRNodeWrapper next = GroupNodeMembers.this.get(i);
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public JCRNodeWrapper previous() {
            try {
                int i = this.cursor - 1;
                JCRNodeWrapper previous = GroupNodeMembers.this.get(i);
                this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(JCRNodeWrapper e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(JCRNodeWrapper e) {
            throw new UnsupportedOperationException();
        }
    }
}

