/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo
implements Comparable {
    private static transient Logger logger = LoggerFactory.getLogger(VersionInfo.class);
    private Version version;
    private String label;
    private int depth;

    public VersionInfo(Version version, String label, int depth) {
        this.version = version;
        this.label = label;
        this.depth = depth;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getLabel() {
        return this.label;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionInfo that = (VersionInfo)o;
        if (this.label != null) {
            return this.label.equals(that.label);
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        if (this.label != null) {
            return this.label.hashCode();
        }
        return 31 * this.version.hashCode();
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        VersionInfo that = (VersionInfo)o;
        if (this.equals(that)) {
            return 0;
        }
        if (this.label != null && that.label != null) {
            return this.label.compareTo(that.label);
        }
        try {
            return this.version.getCreated().compareTo(that.version.getCreated());
        }
        catch (RepositoryException re) {
            logger.error("Error while comparing versions ", (Throwable)re);
            return 0;
        }
    }
}

